package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核通知信息表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_notification")
@ApiModel(value="BizSupplierPerformanceEvaluationNotification对象", description="供应商绩效考核通知信息表")
public class BizSupplierPerformanceEvaluationNotification extends BizDelModel<BizSupplierPerformanceEvaluationNotification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "处理类型（1质量预警，2限期整改，3淘汰）")
    @TableField("process_type_")
    private String processType;

    @ApiModelProperty(value = "通知标题")
    @TableField("notification_title_")
    private String notificationTitle;

    @ApiModelProperty(value = "通知内容")
    @TableField("notification_content_")
    private String notificationContent;

    @ApiModelProperty(value = "企业联系人")
    @TableField("enterprise_contact_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("enterprise_tel_")
    private String enterpriseTel;

    @ApiModelProperty(value = "企业联系地址")
    @TableField("enterprise_address_")
    private String enterpriseAddress;

    @ApiModelProperty(value = "通知日期")
    @TableField("notify_date_")
    private LocalDateTime notifyDate;

    @ApiModelProperty(value = "要求回复截止日期")
    @TableField("reply_deadline_")
    private LocalDateTime replyDeadline;

    @ApiModelProperty(value = "要求完成截止日期")
    @TableField("finish_deadline_")
    private LocalDateTime finishDeadline;

    @ApiModelProperty(value = "通知状态(1已发送，2已确认，3已超期，4已关闭)")
    @TableField("notification_status_")
    private String notificationStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
