package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核配置明细表
 *
 * @author huqi
 * @since 2025-11-11
 */
@Data
@TableName("biz_supplier_performance_evaluation_details")
@ApiModel(value="BizSupplierPerformanceEvaluationDetails对象", description="供应商绩效考核配置明细表")
public class BizSupplierPerformanceEvaluationDetails extends BizDelModel<BizSupplierPerformanceEvaluationDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评审配置ID")
    @TableField("PERFORMANCE_EVALUATION_CONFIGURATION_ID_")
    private String performanceEvaluationConfigurationId;

    @ApiModelProperty(value = "绩效考核分类ID")
    @TableField("ASSESSMENT_INDICATOR_TYPE_ID_")
    private String assessmentIndicatorTypeId;

    @ApiModelProperty(value = "绩效考核分类CODE")
    @TableField("ASSESSMENT_INDICATOR_TYPE_CODE_")
    private String assessmentIndicatorTypeCode;

    @ApiModelProperty(value = "绩效考核分类NAME")
    @TableField("ASSESSMENT_INDICATOR_TYPE_NAME_")
    private String assessmentIndicatorTypeName;

    @ApiModelProperty(value = "评审指标编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "评审内容")
    @TableField("CONTENT_")
    private String content;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    @TableField("WEIGHT_")
    private Float weight;

    @ApiModelProperty(value = "状态(1：启用，0：禁用)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
