package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核整改处理记录表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_correction_report_record")
@ApiModel(value="BizSupplierPerformanceEvaluationCorrectionReportRecord对象", description="供应商绩效考核整改处理记录表")
public class BizSupplierPerformanceEvaluationCorrectionReportRecord extends BizDelModel<BizSupplierPerformanceEvaluationCorrectionReportRecord> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "整改措施报告表ID")
    @TableField("PERFORMANCE_EVALUATION_CORRECTION_REPORT_ID_")
    private String performanceEvaluationCorrectionReportId;

    @ApiModelProperty(value = "通知ID")
    @TableField("notification_id_")
    private String notificationId;

    @ApiModelProperty(value = "任务单号（系统生成）")
    @TableField("JOB_NUM_")
    private String jobNum;

    @ApiModelProperty(value = "节点状态（与绩效考核评价表状态保持一致）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "是否首节点（0否，1是）")
    @TableField("FIRST_NODE_")
    private String firstNode;

    @ApiModelProperty(value = "是否尾节点（0否，1是）")
    @TableField("TAIL_NODE_")
    private String tailNode;

    @ApiModelProperty(value = "处理人ID")
    @TableField("APPROVAL_ID_")
    private String approvalId;

    @ApiModelProperty(value = "处理人ACCOUNT")
    @TableField("APPROVAL_ACCOUNT_")
    private String approvalAccount;

    @ApiModelProperty(value = "处理人")
    @TableField("APPROVAL_NAME_")
    private String approvalName;

    @ApiModelProperty(value = "处理人单位ID")
    @TableField("APPROVAL_ORG_ID_")
    private String approvalOrgId;

    @ApiModelProperty(value = "处理人单位CODE")
    @TableField("APPROVAL_ORG_CODE_")
    private String approvalOrgCode;

    @ApiModelProperty(value = "处理人单位")
    @TableField("APPROVAL_ORG_NAME_")
    private String approvalOrgName;

    @ApiModelProperty(value = "处理时间")
    @TableField("APPROVAL_DATE_")
    private LocalDateTime approvalDate;

    @ApiModelProperty(value = "处理结果（0驳回，1通过）")
    @TableField("APPROVAL_RESULT_")
    private String approvalResult;

    @ApiModelProperty(value = "处理意见")
    @TableField("APPROVAL_OPINION_")
    private String approvalOpinion;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

}
