package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商考核整改措施报告表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_correction_report")
@ApiModel(value="BizSupplierPerformanceEvaluationCorrectionReport对象", description="供应商考核整改措施报告表")
public class BizSupplierPerformanceEvaluationCorrectionReport extends BizDelModel<BizSupplierPerformanceEvaluationCorrectionReport> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "通知ID")
    @TableField("notification_id_")
    private String notificationId;

    @ApiModelProperty(value = "根本原因分析")
    @TableField("root_cause_analysis_")
    private String rootCauseAnalysis;

    @ApiModelProperty(value = "临时应急措施")
    @TableField("temporary_measure_")
    private String temporaryMeasure;

    @ApiModelProperty(value = "长期纠正措施	")
    @TableField("long_term_correction_")
    private String longTermCorrection;

    @ApiModelProperty(value = "计划完成日期")
    @TableField("plan_complete_date_")
    private LocalDate planCompleteDate;

    @ApiModelProperty(value = "实际完成日期")
    @TableField("actual_complete_date_")
    private LocalDate actualCompleteDate;

    @ApiModelProperty(value = "整改状态(1进行中，2已完成，3已验收，4已关闭)")
    @TableField("correction_status_")
    private String correctionStatus;

    @ApiModelProperty(value = "整改结果描述")
    @TableField("result_description_")
    private String resultDescription;

    @ApiModelProperty(value = "验收人ID")
    @TableField("acknowledged_by_id_")
    private String acknowledgedById;

    @ApiModelProperty(value = "验收人ACCOUNT")
    @TableField("acknowledged_by_account_")
    private String acknowledgedByAccount;

    @ApiModelProperty(value = "验收人")
    @TableField("acknowledged_by_name_")
    private String acknowledgedByName;

    @ApiModelProperty(value = "验收时间")
    @TableField("accept_time_")
    private LocalDateTime acceptTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
