package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核评价表-参数用户
 *
 * @company supplierEva
 * @author huqi
 * @since 2025-11-24
 */
@Data
@TableName("biz_supplier_performance_evaluation_configuration_user")
@ApiModel(value="BizSupplierPerformanceEvaluationSupplier对象", description="供应商绩效考核评价表-参数用户")
public class BizSupplierPerformanceEvaluationConfigurationUser extends BizDelModel<BizSupplierPerformanceEvaluationConfigurationUser> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "绩效考核配置ID")
    @TableField("VALUATION_CONFIGURATION_ID_")
    private String valuationConfigurationId;

    @ApiModelProperty(value = "绩效考核配置NAME")
    @TableField("VALUATION_CONFIGURATION_NAME_")
    private String valuationConfigurationName;

    @ApiModelProperty(value = "绩效考核配置CODE")
    @TableField("VALUATION_CONFIGURATION_CODE_")
    private String valuationConfigurationCode;

//    @ApiModelProperty(value = "评价分发场次")
//    @TableField("EVALUATION_NUMBER_")
//    private String evaluationNumber;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "供应商编号")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

}
