package com.artfess.gyl.supplierEva.manager.impl;

import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationApprovalRecord;
import com.artfess.gyl.supplierEva.dao.BizSupplierPerformanceEvaluationApprovalRecordDao;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationApprovalRecordManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * 供应商绩效考核处理记录表 服务实现类
 *
 * @author huqi
 * @since 2025-11-12
 */
@Service
public class BizSupplierPerformanceEvaluationApprovalRecordManagerImpl extends BaseManagerImpl<BizSupplierPerformanceEvaluationApprovalRecordDao, BizSupplierPerformanceEvaluationApprovalRecord> implements BizSupplierPerformanceEvaluationApprovalRecordManager {

    @Override
    public void fillModel(BizSupplierPerformanceEvaluationApprovalRecord entity) {
        String status = entity.getStatus();
        LocalDateTime now = LocalDateTime.now();
        entity.setJobNum(now.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        entity.setFirstNode("2".equals(status)?"1":"0");
        entity.setTailNode("1".equals(status)?"1":"0");
        entity.setApprovalDate(now);
        super.save(entity);
    }
}
