package com.artfess.gyl.supplierEva.manager;

import com.artfess.gyl.supplierEva.dto.ProcessDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationCorrectionReport;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.base.manager.BaseManager;

import java.awt.geom.RectangularShape;

/**
 * 供应商绩效考核通知信息表 服务类
 *
 * @author huqi
 * @since 2025-11-12
 */
public interface BizSupplierPerformanceEvaluationNotificationManager extends BaseManager<BizSupplierPerformanceEvaluationNotification> {

    /**
     * 保存评价
     * @param dto
     * @return
     */
    void saveEva(ResultEvaDTO dto);

    /**
     * 通知确认
     * @param dto
     * @return
     */
    boolean confirmNotification(ProcessDTO dto);

    /**
     * 整改措施审批流程
     * @param dto
     * @return
     */
    boolean updateReportStatus(ProcessDTO dto);

    /**
     * 根据通知单id获取措施报告
     * @param notificationId
     * @return
     */
    BizSupplierPerformanceEvaluationCorrectionReport getReport(String notificationId);
}
