package com.artfess.gyl.supplierEva.dto;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class ResultEvaDTO {

    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "评价结论（1合格，2可改善，3不合格）")
    private String assessmentResult;

    @ApiModelProperty(value = "考核评价ID")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "处理类型（1质量预警，2限期整改，3淘汰）")
    private String processType;

    @ApiModelProperty(value = "通知标题")
    private String notificationTitle;

    @ApiModelProperty(value = "通知内容")
    private String notificationContent;

    @ApiModelProperty(value = "通知日期")
    private LocalDateTime notifyDate;

    @ApiModelProperty(value = "要求回复截止日期")
    private LocalDateTime replyDeadline;

    @ApiModelProperty(value = "要求完成截止日期")
    private LocalDateTime finishDeadline;

    @ApiModelProperty(value = "通知状态(1已发送，2已确认，3已超期，4已关闭)")
    private String notificationStatus;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "企业联系人")
    @TableField("enterprise_contact_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("enterprise_tel_")
    private String enterpriseTel;

    @ApiModelProperty(value = "企业联系地址")
    @TableField("enterprise_address_")
    private String enterpriseAddress;
}
