package com.artfess.gyl.supplierEva.dao;

import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply.vo.SupplierCountVo;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluation;
import com.artfess.gyl.supplierEva.vo.CorePerformanceVo;
import com.artfess.gyl.supplierEva.vo.EvaluationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;
import com.artfess.gyl.supplierEva.vo.SupplierScore;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商绩效考核评价表 Mapper 接口
 *
 * @author huqi
 * @since 2025-11-12
 */
public interface BizSupplierPerformanceEvaluationDao extends BaseMapper<BizSupplierPerformanceEvaluation> {

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<EvaluationVo> queryByEva(IPage<BizSupplierPerformanceEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierPerformanceEvaluation> convert2Wrapper);

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<EvaluationVo> queryByUser(IPage<BizSupplierPerformanceEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierPerformanceEvaluation> convert2Wrapper,@Param("account")String account);

    /**
     * 预警分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<EvaluationVo> queryByEarly(IPage<BizSupplierPerformanceEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierPerformanceEvaluation> convert2Wrapper);


    /**
     *
     * 根据用户,模块配置id,评审项id查询供应商
     * @param account
     * @param evaluationId
     * @param detailsId
     * @return
     */
    List<SupplierScore> getSupplierScores(@Param("account")String account, @Param("evaluationId")String evaluationId, @Param("detailsId")String detailsId);


    /**
     *
     * 根据用户,模块配置id,评审项id查询供应商
     * @param id
     * @return
     */
    List<SupplierScore> getUserEvaluations(@Param("id")String id);

    /**
     * 分页查询
     * @param convert2IPage
     * @param convert2Wrapper
     * @return
     */
    IPage<CorePerformanceVo> countSupplierLevel(IPage<BizSupplierPerformanceEvaluation> convert2IPage, @Param(Constants.WRAPPER) Wrapper<BizSupplierPerformanceEvaluation> convert2Wrapper);
}
