package com.artfess.gyl.supplierEva.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.gyl.supplierEva.dto.ProcessDTO;
import com.artfess.gyl.supplierEva.dto.ResultEvaDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationNotificationManager;

/**
 * 供应商绩效考核通知信息表 前端控制器
 *
 * @author huqi
 * @since 2025-11-12
 */
@RestController
@RequestMapping("/bizSupplierPerformanceEvaluationNotification/v1/")
@Api(tags = "供应商绩效考核-信息通知")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierPerformanceEvaluationNotificationController extends BaseController<BizSupplierPerformanceEvaluationNotificationManager, BizSupplierPerformanceEvaluationNotification> {

    @PostMapping(value = "/confirmNotification", produces = {"application/json; charset=utf-8"})
    @ApiOperation("提醒确认")
    public CommonResult<String> userEva(@RequestBody ProcessDTO dto) {
        boolean result = baseService.confirmNotification(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"操作成功");
    }

    @PostMapping(value = "/updateReportStatus", produces = {"application/json; charset=utf-8"})
    @ApiOperation("流程审评")
    public CommonResult<String> updateReportStatus(@RequestBody ProcessDTO dto) {
        boolean result = baseService.updateReportStatus(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"操作成功");
    }
}
