package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-客户抱怨（上年度）
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_main_products_performance_customer_complaints3")
@ApiModel(value="BizSupplierMainProductsPerformanceCustomerComplaints3对象", description="主营产品情况及质量业绩表-客户抱怨（上年度）")
public class BizSupplierMainProductsPerformanceCustomerComplaints3 extends BizDelModel<BizSupplierMainProductsPerformanceCustomerComplaints3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主营产品情况及质量业绩ID")
    @TableField("SUPPLIER_MAIN_PRODUCTS_PERFORMANCE_ID_")
    private String supplierMainProductsPerformanceId;

    @ApiModelProperty(value = "客户抱怨问题")
    @TableField("CUSTOMER_COMPLAINTS_")
    private String customerComplaints;

    @ApiModelProperty(value = "提出时间")
    @TableField("PROPOSED_TIME_")
    private LocalDate proposedTime;

    @ApiModelProperty(value = "控制措施")
    @TableField("CONTROL_MEASURES_")
    private String controlMeasures;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Long seq;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;

}
