package com.artfess.gyl.supplierApply3.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionProcessFlow3Manager;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessFlow3;
import com.artfess.gyl.supplierApply3.model.BizSupplierProductionProcessPerformance3;
import com.artfess.gyl.supplierApply3.dao.BizSupplierProductionProcessPerformance3Dao;
import com.artfess.gyl.supplierApply3.manager.BizSupplierProductionProcessPerformance3Manager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 生产制造过程绩效表 服务实现类
 *
 * @author huqi
 * @since 2025-11-17
 */
@Service
public class BizSupplierProductionProcessPerformance3ManagerImpl extends BaseManagerImpl<BizSupplierProductionProcessPerformance3Dao, BizSupplierProductionProcessPerformance3> implements BizSupplierProductionProcessPerformance3Manager {

    @Resource
    private BizSupplierProductionProcessFlow3Manager flow3Manager;

    @Resource
    private FileManager fileManager;

    @Override
    public boolean fillModel(BizSupplierProductionProcessPerformance3 performance3, String id, Long version) {
        if (performance3 == null) {
            return true;
        }

        // 设置主实体属性
        performance3.setId(null);
        performance3.setSupplierEnterpriseId(id);
        performance3.setVersion(version);

        // 保存主实体
        if (!super.save(performance3)) {
            throw new ApplicationException("生产制造过程绩效保存失败");
        }
        //处理附件
        List<DefaultFile> files = performance3.getFiles();
        if ( files!= null && files.size() > 0) {
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            //删除未在本次更新内的附件
            fileManager.removeFileByBizId(performance3.getId(),fileIds);
            //更新附件
            fileManager.updateFileBizIdByIds(fileIds, performance3.getId());
        }else {
            fileManager.removeFileByBizId(performance3.getId(),null);
        }
        // 处理关联的流程数据
        if (performance3.getFlow() != null && !performance3.getFlow().isEmpty()) {
            List<BizSupplierProductionProcessFlow3> flow3List = performance3.getFlow().stream()
                    .peek(flow3 -> {
                        flow3.setSupplierProductionProcessPerformanceId(performance3.getId());
                        flow3.setVersion(version);
                        flow3.setId(null);
                    })
                    .collect(Collectors.toList());

            flow3Manager.saveBatch(flow3List);
        }
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierProductionProcessPerformance3 getModel(String id) {
        // 1. 根据 supplierEnterpriseId 查询主实体
        LambdaQueryWrapper<BizSupplierProductionProcessPerformance3> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizSupplierProductionProcessPerformance3::getSupplierEnterpriseId, id);
        BizSupplierProductionProcessPerformance3 performance3 = this.getOne(queryWrapper);
        if (performance3 == null) {
            return null;
        }
        List<DefaultFile> files = fileManager.queryFileByBizId(performance3.getId());
        if (files!= null && files.size() > 0) {
            performance3.setFiles(files);
        }
        // 2. 查询关联的 flow 数据
        LambdaQueryWrapper<BizSupplierProductionProcessFlow3> flowQuery = new LambdaQueryWrapper<>();
        flowQuery.eq(BizSupplierProductionProcessFlow3::getSupplierProductionProcessPerformanceId, performance3.getId());
        List<BizSupplierProductionProcessFlow3> flow = flow3Manager.list(flowQuery);
        // 3. 设置关联数据到主实体
        performance3.setFlow(flow);
        return performance3;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteModelById(String id) {
        try {
            // 1. 先查询出主实体
            LambdaQueryWrapper<BizSupplierProductionProcessPerformance3> queryWrapper =
                    new LambdaQueryWrapper<BizSupplierProductionProcessPerformance3>()
                            .eq(BizSupplierProductionProcessPerformance3::getSupplierEnterpriseId, id);

            BizSupplierProductionProcessPerformance3 performance3 = super.getOne(queryWrapper);

            if (performance3 == null) {
                return true;
            }

            String mainId = performance3.getId();

            // 2. 先删除关联的流程数据
            LambdaQueryWrapper<BizSupplierProductionProcessFlow3> flowWrapper =
                    new LambdaQueryWrapper<BizSupplierProductionProcessFlow3>()
                            .eq(BizSupplierProductionProcessFlow3::getSupplierProductionProcessPerformanceId, mainId);
            flow3Manager.remove(flowWrapper);

            // 3. 最后删除主实体
            boolean removeMain = super.removeById(mainId);

            if (!removeMain) {
                throw new ApplicationException("生产制造过程绩效主表删除失败");
            }
            return true;
        } catch (Exception e) {
            throw new ApplicationException("删除生产制造过程绩效失败: " + e.getMessage());
        }
    }
}
