package com.artfess.gyl.supplierApply3.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsPerformanceCustomerComplaints3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsQualityPerformance3Manager;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsSalesStatus3Manager;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformance3;
import com.artfess.gyl.supplierApply3.dao.BizSupplierMainProductsPerformance3Dao;
import com.artfess.gyl.supplierApply3.manager.BizSupplierMainProductsPerformance3Manager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsPerformanceCustomerComplaints3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsQualityPerformance3;
import com.artfess.gyl.supplierApply3.model.BizSupplierMainProductsSalesStatus3;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 主营产品情况及质量业绩 服务实现类
 *
 * @author huqi
 * @since 2025-11-17
 */
@Service
public class BizSupplierMainProductsPerformance3ManagerImpl extends BaseManagerImpl<BizSupplierMainProductsPerformance3Dao, BizSupplierMainProductsPerformance3> implements BizSupplierMainProductsPerformance3Manager {

    @Resource
    private BizSupplierMainProductsPerformanceCustomerComplaints3Manager complaints3Manager;

    @Resource
    private FileManager fileManager;

    @Resource
    private BizSupplierMainProductsQualityPerformance3Manager qualityPerformance3Manager;

    @Override
    public boolean fillModel(BizSupplierMainProductsPerformance3 performance3, String id, Long version) {
        if (performance3 != null) {
            // 1. 批量设置主实体属性并保存
            performance3.setId(null);
            performance3.setSupplierEnterpriseId(id);
            performance3.setVersion(version);

            if (!super.save(performance3)) {
                throw new ApplicationException("主营产品情况及质量业绩保存失败");
            }

            //处理附件
            List<DefaultFile> files = performance3.getFiles();
            if ( files!= null && files.size() > 0) {
                List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
                //删除未在本次更新内的附件
                fileManager.removeFileByBizId(performance3.getId(),fileIds);
                //更新附件
                fileManager.updateFileBizIdByIds(fileIds, performance3.getId());
            }else {
                fileManager.removeFileByBizId(performance3.getId(),null);
            }
            // 处理客户投诉数据
            if (performance3.getComplaints() != null && !performance3.getComplaints().isEmpty()) {
                List<BizSupplierMainProductsPerformanceCustomerComplaints3> complaints3List =
                        performance3.getComplaints().stream()
                                .peek(complaint -> {
                                    complaint.setId(null);
                                    complaint.setSupplierMainProductsPerformanceId(performance3.getId());
                                    complaint.setVersion(performance3.getVersion());
                                })
                                .collect(Collectors.toList());
                complaints3Manager.saveBatch(complaints3List);
            }

            // 处理销售状态数据
//            if (performance3.getSalesStatus() != null && !performance3.getSalesStatus().isEmpty()) {
//                List<BizSupplierMainProductsSalesStatus3> salesStatus3List =
//                        performance3.getSalesStatus().stream()
//                                .peek(salesStatus -> {
//                                    salesStatus.setId(null);
//                                    salesStatus.setSupplierMainProductsPerformanceId(performance3.getId());
//                                    salesStatus.setVersion(performance3.getVersion());
//                                })
//                                .collect(Collectors.toList());
//                status3Manager.saveBatch(salesStatus3List);
//            }

            // 处理质量业绩数据
            if (performance3.getQualityPerformance() != null && !performance3.getQualityPerformance().isEmpty()) {
                List<BizSupplierMainProductsQualityPerformance3> qualityPerformance3List =
                        performance3.getQualityPerformance().stream()
                                .peek(qualityPerformance3 -> {
                                    qualityPerformance3.setId(null);
                                    qualityPerformance3.setSupplierMainProductsPerformanceId(performance3.getId());
                                    qualityPerformance3.setVersion(performance3.getVersion());
                                })
                                .collect(Collectors.toList());
                qualityPerformance3Manager.saveBatch(qualityPerformance3List);
            }
        }
        return true;
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierMainProductsPerformance3 getModel(String id) {
        // 1. 根据 supplierEnterpriseId 查询主实体列表
        LambdaQueryWrapper<BizSupplierMainProductsPerformance3> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(BizSupplierMainProductsPerformance3::getSupplierEnterpriseId, id);
        BizSupplierMainProductsPerformance3 performance = this.getOne(queryWrapper);

        if (performance==null) {
            return null;
        }

        String performanceId = performance.getId();

        List<DefaultFile> files = fileManager.queryFileByBizId(performanceId);
        if (files!= null && files.size() > 0) {
            performance.setFiles(files);
        }
        // 3. 批量查询关联数据 - 客户投诉
        LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints3> complaintsQuery = new LambdaQueryWrapper<>();
        complaintsQuery.eq(BizSupplierMainProductsPerformanceCustomerComplaints3::getSupplierMainProductsPerformanceId, performanceId);
        List<BizSupplierMainProductsPerformanceCustomerComplaints3> complaintsList = complaints3Manager.list(complaintsQuery);

        // 4. 批量查询关联数据 - 销售状态
//        LambdaQueryWrapper<BizSupplierMainProductsSalesStatus3> salesStatusQuery = new LambdaQueryWrapper<>();
//        salesStatusQuery.eq(BizSupplierMainProductsSalesStatus3::getSupplierMainProductsPerformanceId, performanceId);
//        List<BizSupplierMainProductsSalesStatus3> salesStatusList = status3Manager.list(salesStatusQuery);

        // 5. 批量查询关联数据 - 质量业绩
        LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance3> qualityQuery = new LambdaQueryWrapper<>();
        qualityQuery.eq(BizSupplierMainProductsQualityPerformance3::getSupplierMainProductsPerformanceId, performanceId);
        List<BizSupplierMainProductsQualityPerformance3> qualityList = qualityPerformance3Manager.list(qualityQuery);

        // 6. 将关联数据设置到主实体中
            // 设置客户投诉数据
            List<BizSupplierMainProductsPerformanceCustomerComplaints3> performanceComplaints = complaintsList.stream()
                    .filter(complaint -> complaint.getSupplierMainProductsPerformanceId().equals(performance.getId()))
                    .collect(Collectors.toList());
            performance.setComplaints(performanceComplaints);

            // 设置销售状态数据
//            List<BizSupplierMainProductsSalesStatus3> performanceSalesStatus = salesStatusList.stream()
//                    .filter(salesStatus -> salesStatus.getSupplierMainProductsPerformanceId().equals(performance.getId()))
//                    .collect(Collectors.toList());
//            performance.setSalesStatus(performanceSalesStatus);

            // 设置质量业绩数据
            List<BizSupplierMainProductsQualityPerformance3> performanceQuality = qualityList.stream()
                    .filter(quality -> quality.getSupplierMainProductsPerformanceId().equals(performance.getId()))
                    .collect(Collectors.toList());
            performance.setQualityPerformance(performanceQuality);

        return performance;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean deleteModelById(String id) {
        try {
            BizSupplierMainProductsPerformance3 performance4 = super.getOne(new LambdaQueryWrapper<BizSupplierMainProductsPerformance3>().eq(BizSupplierMainProductsPerformance3::getSupplierEnterpriseId, id));
            if (performance4==null) {
                return true;
            }
            String mainId = performance4.getId();
            // 1. 先删除关联的子表数据
            // 删除质量业绩数据
            LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance3> qualityWrapper =
                    new LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance3>()
                            .eq(BizSupplierMainProductsQualityPerformance3::getSupplierMainProductsPerformanceId, mainId)
                            ;
            qualityPerformance3Manager.remove(qualityWrapper);
            // 删除销售状态数据
//            LambdaQueryWrapper<BizSupplierMainProductsSalesStatus3> salesStatusWrapper =
//                    new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus3>()
//                            .eq(BizSupplierMainProductsSalesStatus3::getSupplierMainProductsPerformanceId, mainId)
//                            ;
//            status3Manager.remove(salesStatusWrapper);
            // 删除客户投诉数据
            LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints3> complaintsWrapper =
                    new LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints3>()
                            .eq(BizSupplierMainProductsPerformanceCustomerComplaints3::getSupplierMainProductsPerformanceId, mainId)
                           ;
            complaints3Manager.remove(complaintsWrapper);
            // 2. 最后删除主实体
            boolean removeMain = super.removeById(mainId);
            if (!removeMain) {
                throw new ApplicationException("主营产品情况及质量业绩主表删除失败");
            }
            return true;
        } catch (Exception e) {
            throw new ApplicationException("删除主营产品情况及质量业绩失败: " + e.getMessage());
        }
    }
}
