package com.artfess.gyl.supplierApply2.vo;

import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;

@Data
public class EnterpriseAccess2PageVo {

    @ApiModelProperty(value = "准入申请ID")
    private String id;

    @ApiModelProperty(value = "供方名称")
    private String supplierName;

    @ApiModelProperty(value = "客户名称")
    private String enterpriseName;

    @ApiModelProperty(value = "拟供应物资类型")
    private String materialCategoryName;

    @ApiModelProperty(value = "准入资质配置名称")
    private String accessConfigurationName;

    @ApiModelProperty(value = "供应商合作意愿（1一般，2强烈，3较强烈）")
    private String cooperateWillingness;

    @ApiModelProperty(value = "类型")
    private String ownerType;

    @ApiModelProperty(value = "法定代表人")
    private String companyEbe;

    @ApiModelProperty(value = "注册资金(万元)")
    private Double registeredCapital;

    @ApiModelProperty(value = "状态（0保存草稿，1提交申请，2基本情况审核，3确认评审方案，4现场评审，5评审报告，6样品试用，7准入报告（已完成），8取消）")
    private String status;

    @ApiModelProperty(value = "邀请时间")
    private LocalDateTime applyDate;

    @ApiModelProperty(value = "申请时间")
    private LocalDateTime submitDate;

    @ApiModelProperty(value = "创建方式（1企业直接添加，2供应商准入申请，3企业准入申请）")
    private String createMethod;

    @ApiModelProperty(value = "是否可审批（1是，0否）")
    private String couldAudit;
}
