package com.artfess.gyl.supplierApply2.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入评审评分明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-18
 */
@Data
@ApiModel(value="BizSupplierReviewRatingDetails2对象", description="供应商准入评审评分明细表")
public class BizSupplierReviewRatingDetails2 extends BizDelModel<BizSupplierReviewRatingDetails2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "评审配置ID（关联准入评审评分表ID）")
    @TableField("REVIEW_CONFIGURATION_ID_")
    private String reviewConfigurationId;

    @ApiModelProperty(value = "配置指标明细ID（关联准入评审配置指标明细表ID）")
    @TableField("REVIEW_CONFIGURATION_DETAILS_ID_")
    private String reviewConfigurationDetailsId;

    @ApiModelProperty(value = "指标类别名称")
    @TableField("CLASSIFICATION_NAME_")
    private String classificationName;

    @ApiModelProperty(value = "指标类别编码")
    @TableField("CLASSIFICATION_CODE_")
    private String classificationCode;

    @ApiModelProperty(value = "评审指标编码")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "评审内容")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "评审要求")
    @TableField("DESC_")
    private String desc;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    @TableField("WEIGHT_")
    private Float weight;

    @ApiModelProperty(value = "评分人ID")
    @TableField("RATING_ID_")
    private String ratingId;

    @ApiModelProperty(value = "评分人ACCOUNT")
    @TableField("RATING_ACCOUNT_")
    private String ratingAccount;

    @ApiModelProperty(value = "评分人")
    @TableField("RATING_NAME_")
    private String ratingName;

    @ApiModelProperty(value = "评分操作人ID")
    @TableField("OPERATION_RATING_ID_")
    private String operationRatingId;

    @ApiModelProperty(value = "评分操作人ACCOUNT")
    @TableField("OPERATION_RATING_ACCOUNT_")
    private String operationRatingAccount;

    @ApiModelProperty(value = "评分操作人")
    @TableField("OPERATION_RATING_NAME_")
    private String operationRatingName;

    @ApiModelProperty(value = "评分时间")
    @TableField("RATING_TIME_")
    private LocalDateTime ratingTime;

    @ApiModelProperty(value = "得分")
    @TableField("OPERATION_SCORE_")
    private BigDecimal operationScore;

    @ApiModelProperty(value = "状态(1：已完成，0：未完成)")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
