package com.artfess.gyl.supplierApply2.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商人员信息表（通过原biz_enterprise进行扩展）		说明：供应商基本信息变更后通过
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-23
 */
@Data
@ApiModel(value="BizSupplierAccessPersonnel2对象", description="供应商人员信息表（通过原biz_enterprise进行扩展）		说明：供应商基本信息变更后通过")
public class BizSupplierAccessPersonnel2 extends BizDelModel<BizSupplierAccessPersonnel2> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "供应商准入ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "企业信息ID（关联企业信息表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "姓名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "性别")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "出生日期")
    @TableField("BIRTHDAY_")
    private String birthday;

    @ApiModelProperty(value = "学历")
    @TableField("EDUCATION_BACKGROUND_")
    private String educationBackground;

    @ApiModelProperty(value = "职位")
    @TableField("POST_")
    private String post;

    @ApiModelProperty(value = "联系方式")
    @TableField("PHONE_")
    private String phone;

    @ApiModelProperty(value = "人员类型（topManager:企业高管人员，businessPerson:业务联系人，qualityPerson:质量联系人）")
    @TableField("TYPE_")
    private String type;
}
