package com.artfess.gyl.supplierApply2.dao;

import com.artfess.gyl.supplierApply2.model.BizSupplierEnterpriseAccess;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierApply2.vo.UserVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * 供应商准入申请表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-10
 */
public interface BizSupplierEnterpriseAccessDao extends BaseMapper<BizSupplierEnterpriseAccess> {

    /**
     * 根据ID查询用户
     * @param rpaSet
     * @return
     */
    List<UserVo> selectUser(@Param("rpaSet") Set<String> rpaSet);

    /**
     * 获取订单总金额
     * @param supplierId
     * @return
     */
    String selectTotalAmount(@Param("supplierId") String supplierId);

    IPage<EnterpriseAccess2PageVo> queryPage(IPage<BizSupplierEnterpriseAccess> convert2IPage,
                                             @Param(Constants.WRAPPER) QueryWrapper<BizSupplierEnterpriseAccess> convert2Wrapper,
                                             @Param("userId") String userId);
}
