package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 试用评审报告评审成员
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Data
@ApiModel(value="BizSupplierReviewTrialReportPanel对象", description="试用评审报告评审成员")
public class BizSupplierReviewTrialReportPanel extends BizDelModel<BizSupplierReviewTrialReportPanel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评定报告ID")
    @TableField("REVIEW_REPORT_ID_")
    private String reviewReportId;

    @ApiModelProperty(value = "评审人ID")
    @TableField("OPERATION_RATING_ID_")
    private String operationRatingId;

    @ApiModelProperty(value = "评审人ACCOUNT")
    @TableField("OPERATION_RATING_ACCOUNT_")
    private String operationRatingAccount;

    @ApiModelProperty(value = "评审人")
    @TableField("OPERATION_RATING_NAME_")
    private String operationRatingName;
}
