package com.artfess.gyl.supplierApply.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入评审评分评审成员表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-02
 */
@Data
@ApiModel(value="BizSupplierReviewRatingPanel对象", description="供应商准入评审评分评审成员表")
public class BizSupplierReviewRatingPanel extends BizDelModel<BizSupplierReviewRatingPanel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "评审评分指标ID")
    @TableField("REVIEW_RATING_DETAILS_ID_")
    private String reviewRatingDetailsId;

    @ApiModelProperty(value = "分值")
    @TableField("SCORE_")
    private Integer score;

    @ApiModelProperty(value = "权重（百分比）")
    @TableField("WEIGHT_")
    private Float weight;

    @ApiModelProperty(value = "默认评分人ID")
    @TableField("RATING_ID_")
    private String ratingId;

    @ApiModelProperty(value = "默认评分人ACCOUNT")
    @TableField("RATING_ACCOUNT_")
    private String ratingAccount;

    @ApiModelProperty(value = "默认评分人")
    @TableField("RATING_NAME_")
    private String ratingName;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;
}
