package com.artfess.gyl.supplierApply.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.manager.BizSupplierCategoryConfigurationManager;
import com.artfess.gyl.base.manager.BizSupplierGradingConfigurationManager;
import com.artfess.gyl.base.manager.BizSupplierQualificationCategoryManager;
import com.artfess.gyl.base.manager.BizSupplierQualificationDatabaseManager;
import com.artfess.gyl.base.model.BizSupplierCategoryConfiguration;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierAccess.manager.*;
import com.artfess.gyl.supplierAccess.model.BizSupplierAccessBasic;
import com.artfess.gyl.supplierApply.dto.*;
import com.artfess.gyl.supplierApply.manager.*;
import com.artfess.gyl.supplierApply.model.*;
import com.artfess.gyl.supplierApply.dao.BizSupplierEnterpriseDao;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierApply.vo.*;
import com.artfess.gyl.supplierApply2.dto.*;
import com.artfess.gyl.supplierApply2.manager.*;
import com.artfess.gyl.supplierApply2.model.*;
import com.artfess.gyl.supplierApply2.vo.*;
import com.artfess.gyl.supplierApply2.vo.FillingProgressVo;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.gyl.utils.OrgUtils;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.uc.api.impl.model.Org;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 合格供应商表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-20
 */
@Service
public class BizSupplierEnterpriseManagerImpl extends BaseManagerImpl<BizSupplierEnterpriseDao, BizSupplierEnterprise> implements BizSupplierEnterpriseManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Resource
    private BizSupplierMainSupplyMaterialCategoryManager materialCategoryManager;

    @Resource
    private BizSupplierAccessBasicInformationManager informationManager;

    @Resource
    private BizSupplierEnterpriseQualificationDatabaseManager enterpriseQualificationDatabaseManager;

    @Resource
    private BizSupplierMainProductsPerformanceManager mainProductsPerformanceManager;

    @Resource
    private BizSupplierMainProductsQualityPerformanceManager mainProductsQualityPerformanceManager;

    @Resource
    private BizSupplierMainProductsSalesStatusManager mainProductsSalesStatusManager;

    @Resource
    private BizSupplierMainProductsPerformanceCustomerComplaintsManager mainProductsPerformanceCustomerComplaintsManager;

    @Resource
    private BizSupplierMainRawMaterialsSuppliersManager mainRawMaterialsSuppliersManager;

    @Resource
    private BizSupplierProductionProcessPerformanceManager productionProcessPerformanceManager;

    @Resource
    private BizSupplierProductionProcessFlowManager productionProcessFlowManager;

    @Resource
    private BizSupplierProductionInspectionEquipmentManager productionInspectionEquipmentManager;

    @Resource
    private BizSupplierOtherSpecialNotesManager otherSpecialNotesManager;

    @Resource
    private BizEnterpriseManager enterpriseManager;

    @Resource
    private BizSupplierAccessConfigurationManager accessConfigurationManager;

    @Resource
    private BizSupplierAccessQualificationManager qualificationManager;

    @Resource
    private BizSupplierQualificationCategoryManager qualificationCategoryManager;

    @Resource
    private BizSupplierQualificationDatabaseManager qualificationDatabaseManager;

    @Resource
    private BizSupplierEnterpriseAccessApprovalRecord2Manager accessApprovalRecord2Manager;

    @Resource
    private BizSupplierAccessProcessManager accessProcessManager;

    @Resource
    private BizSupplierReviewRatingDetailsManager reviewRatingDetailsManager;

    @Resource
    private BizSupplierReviewReportManager reviewReportManager;

    @Resource
    private BizSupplierReviewReportPanelManager reviewReportPanelManager;

    @Resource
    private BizSupplierReviewTrialReportManager reviewTrialReportManager;

    @Resource
    private BizSupplierReviewTrialReportPanelManager reviewTrialReportPanelManager;

    @Resource
    private BizSupplierReviewConfigurationManager reviewConfigurationManager;

    @Resource
    private BizSupplierReviewConfigurationDetailsManager reviewConfigurationDetailsManager;

    @Resource
    private BizSupplierProductionEquipmentManager productionEquipmentManager;

    @Resource
    private BizSupplierInspectionEquipmentManager inspectionEquipmentManager;

    @Resource
    private BizSupplierReviewRatingPanelManager reviewRatingPanelManager;

    @Resource
    private BizSupplierAccessEnterprisePersonnelManager accessEnterprisePersonnelManager;

    @Resource
    private BizSupplierEnterpriseAccessManager enterpriseAccessManager;

    @Resource
    private BizSupplierAccessBasicManager accessBasicManager;

    @Resource
    private BizSupplierCategoryConfigurationManager categoryConfigurationManager;

    @Resource
    private BizSupplierGradingConfigurationManager gradingConfigurationManager;

    @Resource
    private FileManager fileManager;

    public Boolean saveOrUpdateEnterpriseAccess(EnterpriseDto dto) {
        Boolean result = false;
        if (BeanUtils.isEmpty(dto.getId())){
            //新增
            result = saveEnterpriseAccess(dto);
        }
        //修改
        else {
            result = updateEnterpriseAccess(dto);
        }
        return result;
    }

    /**
     * 保存合格供应商
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveEnterpriseAccess(EnterpriseDto dto){
        boolean result = false;
        result = save(dto);
        if (!result){
            return false;
        }
        List<BizSupplierMainSupplyMaterialCategory> materialCategory2List = dto.getMaterialCategoryList();
        if (BeanUtils.isNotEmpty(materialCategory2List)){
            materialCategory2List.forEach(m -> m.setSupplierEnterpriseId(dto.getId()));
            result = materialCategoryManager.saveBatch(materialCategory2List);
        }
        return result;
    }

    /**
     * 修改准入申请信息
     * @param dto
     * @return
     */
    public Boolean updateEnterpriseAccess(EnterpriseDto dto){
        //删除旧数据
        materialCategoryManager.remove(new LambdaQueryWrapper<BizSupplierMainSupplyMaterialCategory2>()
                .eq(BizSupplierMainSupplyMaterialCategory2::getSupplierEnterpriseId, dto.getId())
                .eq(BizSupplierMainSupplyMaterialCategory2::getIsDele, "0"));

        //保存新数据
        List<BizSupplierMainSupplyMaterialCategory> materialCategory2List = dto.getMaterialCategoryList();
        materialCategory2List.forEach(m -> {
            m.setSupplierEnterpriseId(dto.getId());
            m.setId(null);
        });
        materialCategoryManager.saveBatch(materialCategory2List);
        return updateById(dto);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean saveModel(EnterpriseDto dto) {

        //合格供应商
        saveOrUpdateEnterpriseAccess(dto);
        Boolean result = false;
        String moduleCode = dto.getModuleCode();
        //1 基本情况
        if ("1".equals(moduleCode)){
            result = saveOrUpdateBasicInformation(dto);
        }
        //2 人员信息
        else if ("2".equals(moduleCode)) {
            result = saveOrUpdateAccessPersonel(dto);
        }
        //3 企业规模
        else if ("3".equals(moduleCode)) {
            result = saveOrUpdateBasicInformation(dto);
        }
        //4 企业资质
        else if ("4".equals(moduleCode)) {
            result = saveOrUpdateQualification(dto);
        }
        //5 主营产品情况
        else if ("5".equals(moduleCode)) {
            result = saveOrUpdateMainProductsSalesStatus(dto);
        }
        //6 主营产品质量业绩
        else if ("6".equals(moduleCode)) {
            result = saveOrUpdateMainProductsPerformance(dto);
        }
        //7 主要原材料及供应商
        else if ("7".equals(moduleCode)) {
            result = saveOrUpdateMainRawMaterialsSuppliers(dto);
        }
        //8 生产制造过程绩效
        else if ("8".equals(moduleCode)) {
            result = saveOrUpdateProductionProcessPerformance(dto);
        }
        //9 生产设备
        else if ("9".equals(moduleCode)) {
            result = saveOrUpdateProductionEquipment(dto);
        }
        //10 检验设备
        else if ("10".equals(moduleCode)) {
            result = saveOrUpdateInspectionEquipment(dto);
        }
        //11 其他特别说明
        else if ("11".equals(moduleCode)) {
            result = saveOrUpdateOtherSpecialNotes(dto);
        }
        //12 现场评审
        else if ("12".equals(moduleCode)) {
            result = saveOrUpdateReviewRatingDetails(dto);
        }
        //13 评定报告
        else if ("13".equals(moduleCode)) {
            result = saveOrUpdateReviewReport(dto);
        }
        //14 试生产审评
        else if ("14".equals(moduleCode)) {
            result = saveOrUpdateReviewTrialReport(dto);
        }
        return result;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveFullModel(EnterpriseDto dto){
        //合格供应商
        saveOrUpdateEnterpriseAccess(dto);
        //1 基本情况
        saveOrUpdateBasicInformation(dto);
        //2 人员信息
        saveOrUpdateAccessPersonel(dto);
        //3 企业规模
        saveOrUpdateBasicInformation(dto);
        //4 企业资质
        saveOrUpdateQualification(dto);
        //5 主营产品情况
        saveOrUpdateMainProductsSalesStatus(dto);
        //6 主营产品质量业绩
        saveOrUpdateMainProductsPerformance(dto);
        //7 主要原材料及供应商
        saveOrUpdateMainRawMaterialsSuppliers(dto);
        //8 生产制造过程绩效
        saveOrUpdateProductionProcessPerformance(dto);
        //9 生产设备
        saveOrUpdateProductionEquipment(dto);
        //10 检验设备
        saveOrUpdateInspectionEquipment(dto);
        //11 其他特别说明
        saveOrUpdateOtherSpecialNotes(dto);
        //12 现场评审
        saveOrUpdateReviewRatingDetails(dto);
        //13 评定报告
        saveOrUpdateReviewReport(dto);
        //14 试生产审评
        saveOrUpdateReviewTrialReport(dto);
    }

    @Override
    public EnterpriseVo getInfo(String id) {
        BizSupplierEnterprise enterpriseAccess = get(id);
        EnterpriseVo enterpriseVo = new EnterpriseVo(enterpriseAccess);
        //供应物资
        List<BizSupplierMainSupplyMaterialCategory> mainSupplyMaterialCategoryList = materialCategoryManager.list(new LambdaQueryWrapper<BizSupplierMainSupplyMaterialCategory>()
                .eq(BizSupplierMainSupplyMaterialCategory::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainSupplyMaterialCategory::getIsDele, "0"));
        enterpriseVo.setMaterialCategoryList(mainSupplyMaterialCategoryList);

        //基本情况 企业规模
        BizSupplierAccessBasicInformation information = informationManager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasicInformation>()
                .eq(BizSupplierAccessBasicInformation::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessBasicInformation::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(information)){
            BizSupplierAccessBasicInformationVo informationVo = new BizSupplierAccessBasicInformationVo(information);
            BizEnterprise enterprise = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                    .eq(BizEnterprise::getOrgId, information.getEnterpriseId())
                    .eq(BizEnterprise::getIsDele,"0"));
            informationVo.setEnterprise(enterprise);
            enterpriseVo.setInformation(informationVo);
        }

        //企业资质
        List<BizSupplierEnterpriseQualificationDatabase> qualificationList = enterpriseQualificationDatabaseManager.list(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase>()
                .eq(BizSupplierEnterpriseQualificationDatabase::getSupplierEnterpriseId, id)
                .eq(BizSupplierEnterpriseQualificationDatabase::getIsDele, "0"));
        Map<String, List<BizSupplierEnterpriseQualificationDatabase>> qualificationMap = qualificationList.stream()
                .collect(Collectors.groupingBy(BizSupplierEnterpriseQualificationDatabase::getMustTransmit));
        enterpriseVo.setQualificationMap(qualificationMap);
        //主营产品情况
        List<BizSupplierMainProductsSalesStatus> salesStatusList = mainProductsSalesStatusManager.list(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus>()
                .eq(BizSupplierMainProductsSalesStatus::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainProductsSalesStatus::getIsDele, "0"));
        enterpriseVo.setSalesStatusList(salesStatusList);
        //主营产品质量业绩
        BizSupplierMainProductsPerformance performance = mainProductsPerformanceManager.getOne(new LambdaQueryWrapper<BizSupplierMainProductsPerformance>()
                .eq(BizSupplierMainProductsPerformance::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainProductsPerformance::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(performance)){
            MainProductsPerformanceVo performanceVo = new MainProductsPerformanceVo(performance);
            String productsPerformanceId = performanceVo.getId();
            List<BizSupplierMainProductsQualityPerformance> qualityPerformanceList = mainProductsQualityPerformanceManager.list(new LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance>()
                    .eq(BizSupplierMainProductsQualityPerformance::getSupplierMainProductsPerformanceId, productsPerformanceId)
                    .eq(BizSupplierMainProductsQualityPerformance::getIsDele, "0"));
            List<BizSupplierMainProductsPerformanceCustomerComplaints> customerComplaintsList = mainProductsPerformanceCustomerComplaintsManager.list(new LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints>()
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints::getSupplierMainProductsPerformanceId, productsPerformanceId)
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints::getIsDele, "0"));
            performanceVo.setQualityPerformanceList(qualityPerformanceList);
            performanceVo.setCustomerComplaintsList(customerComplaintsList);
            //附件
            if (BeanUtils.isNotEmpty(performanceVo)){
                List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(performanceVo.getId());
                if (CollectionUtils.isNotEmpty(defaultFiles)){
                    performanceVo.setFiles(defaultFiles);
                }
            }
            enterpriseVo.setMainProductsPerformance(performanceVo);
        }
        //主要原材料及供应商
        List<BizSupplierMainRawMaterialsSuppliers> mainRawMaterialsSuppliersList = mainRawMaterialsSuppliersManager.list(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers>()
                .eq(BizSupplierMainRawMaterialsSuppliers::getSupplierEnterpriseId, id)
                .eq(BizSupplierMainRawMaterialsSuppliers::getIsDele, "0"));
        enterpriseVo.setRawMaterialsSuppliersList(mainRawMaterialsSuppliersList);
        //生产制造过程绩效
        BizSupplierProductionProcessPerformance processPerformance = productionProcessPerformanceManager.getOne(new LambdaQueryWrapper<BizSupplierProductionProcessPerformance>()
                .eq(BizSupplierProductionProcessPerformance::getSupplierEnterpriseId, id)
                .eq(BizSupplierProductionProcessPerformance::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(processPerformance)){
            BizSupplierProductionProcessPerformanceVo processPerformanceVo = new BizSupplierProductionProcessPerformanceVo(processPerformance);
            String processPerformanceId = processPerformance.getId();
            List<BizSupplierProductionProcessFlow> productionProcessFlowList = productionProcessFlowManager.list(new LambdaQueryWrapper<BizSupplierProductionProcessFlow>()
                    .eq(BizSupplierProductionProcessFlow::getSupplierProductionProcessPerformanceId, processPerformanceId)
                    .eq(BizSupplierProductionProcessFlow::getIsDele, "0"));
            processPerformanceVo.setProcessFlowList(productionProcessFlowList);
            //附件
            if (BeanUtils.isNotEmpty(processPerformanceVo)){
                List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(processPerformanceVo.getId());
                if (CollectionUtils.isNotEmpty(defaultFiles)){
                    processPerformanceVo.setFiles(defaultFiles);
                }
            }
            enterpriseVo.setProcessPerformance(processPerformanceVo);
        }
        //生产设备
        List<BizSupplierProductionEquipment> productionEquipmentList = productionEquipmentManager.list(new LambdaQueryWrapper<BizSupplierProductionEquipment>()
                .eq(BizSupplierProductionEquipment::getSupplierEnterpriseId, id)
                .eq(BizSupplierProductionEquipment::getIsDele, "0"));
        enterpriseVo.setProductionEquipmentList(productionEquipmentList);
        //附件
        List<DefaultFile> productionEquipmentFiles = fileManager.queryFileByBizId(id, "productionEquipment");
        enterpriseVo.setProductionEquipmentFiles(productionEquipmentFiles);
        //检验设备
        List<BizSupplierInspectionEquipment> inspectionEquipmentList = inspectionEquipmentManager.list(new LambdaQueryWrapper<BizSupplierInspectionEquipment>()
                .eq(BizSupplierInspectionEquipment::getSupplierEnterpriseId, id)
                .eq(BizSupplierInspectionEquipment::getIsDele, "0"));
        enterpriseVo.setInspectionEquipmentList(inspectionEquipmentList);
        //附件
        List<DefaultFile> inspectionEquipmentFiles = fileManager.queryFileByBizId(id, "inspectionEquipment");
        enterpriseVo.setInspectionEquipmentFiles(inspectionEquipmentFiles);
        //其他特别说明
        BizSupplierOtherSpecialNotes otherSpecialNotes = otherSpecialNotesManager.getOne(new LambdaQueryWrapper<BizSupplierOtherSpecialNotes>()
                .eq(BizSupplierOtherSpecialNotes::getSupplierEnterpriseId, id)
                .eq(BizSupplierOtherSpecialNotes::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(otherSpecialNotes)){
            List<DefaultFile> defaultFiles = fileManager.queryFileByBizId(otherSpecialNotes.getId());
            if (CollectionUtils.isNotEmpty(defaultFiles)){
                otherSpecialNotes.setFiles(defaultFiles);
            }
        }
        enterpriseVo.setOtherSpecialNotes(otherSpecialNotes);
        //现场评审
        String userId = ContextUtil.getCurrentUserId();
        List<BizSupplierReviewRatingDetailsVo> reviewRatingDetailsVoList = reviewRatingDetailsManager.queryWithPanel(id,null);

        Map<String, List<BizSupplierReviewRatingDetailsVo>> reviewRatingDetailsMap = reviewRatingDetailsVoList.stream()
                .collect(Collectors.groupingBy(BizSupplierReviewRatingDetailsVo::getClassificationName));
        enterpriseVo.setReviewRatingDetailsMap(reviewRatingDetailsMap);
        //评定报告
        BizSupplierReviewReport reviewReport = reviewReportManager.getOne(new LambdaQueryWrapper<BizSupplierReviewReport>()
                .eq(BizSupplierReviewReport::getSupplierEnterpriseId, id)
                .eq(BizSupplierReviewReport::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(reviewReport)){
            BizSupplierReviewReportVo reviewReportVo = new BizSupplierReviewReportVo(reviewReport);
            String reviewReportId = reviewReport.getId();
            List<BizSupplierReviewReportPanel> panelList = reviewReportPanelManager.list(new LambdaQueryWrapper<BizSupplierReviewReportPanel>()
                    .eq(BizSupplierReviewReportPanel::getReviewReportId, reviewReportId)
                    .eq(BizSupplierReviewReportPanel::getIsDele, "0"));
            reviewReportVo.setPanelList(panelList);
            enterpriseVo.setReviewReport(reviewReportVo);
        }
        //试生产评审
        BizSupplierReviewTrialReport reviewTrialReport = reviewTrialReportManager.getOne(new LambdaQueryWrapper<BizSupplierReviewTrialReport>()
                .eq(BizSupplierReviewTrialReport::getSupplierEnterpriseId, id)
                .eq(BizSupplierReviewTrialReport::getIsDele, "0"));
        if (BeanUtils.isNotEmpty(reviewTrialReport)){
            BizSupplierReviewTrialReportVo reviewTrialReportVo = new BizSupplierReviewTrialReportVo(reviewTrialReport);
            String trialReportId = reviewTrialReport.getId();
            List<BizSupplierReviewTrialReportPanel> reviewTrialReportPanelList = reviewTrialReportPanelManager.list(new LambdaQueryWrapper<BizSupplierReviewTrialReportPanel>()
                    .eq(BizSupplierReviewTrialReportPanel::getReviewReportId, trialReportId)
                    .eq(BizSupplierReviewTrialReportPanel::getIsDele, "0"));
            reviewTrialReportVo.setPanelList(reviewTrialReportPanelList);
            enterpriseVo.setReviewTrialReport(reviewTrialReportVo);
        }
        //人员信息
        List<BizSupplierAccessEnterprisePersonnel> personnelList = accessEnterprisePersonnelManager.list(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel>()
                .eq(BizSupplierAccessEnterprisePersonnel::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessEnterprisePersonnel::getIsDele, "0"));
        enterpriseVo.setEnterprisePersonnelList(personnelList);
        return enterpriseVo;
    }

    @Override
    public PageList<EnterprisePageVo> queryPage(QueryFilter<BizSupplierEnterprise> queryFilter) throws InvocationTargetException, IllegalAccessException {
        IPage<EnterprisePageVo> iPage = baseMapper.queryPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public PageList<SupplierCountVo> countSupplierGrade(QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("se.IS_DELE_","0", QueryOP.EQUAL);
        queryFilter.addFilter("be.IS_DELE_","0", QueryOP.EQUAL);
        IPage<SupplierCountVo> iPage = baseMapper.countSupplierGrade(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public FillingProgressVo getFillingProgress(String id) {
        FillingProgressVo vo = createFillingProgress(id);
        if (BeanUtils.isEmpty(id)){
            return vo;
        }
        vo.setEnterpriseAccessFlag("1");
        //基本情况 企业规模
        int count1 = informationManager.count(new LambdaQueryWrapper<BizSupplierAccessBasicInformation>()
                .eq(BizSupplierAccessBasicInformation::getSupplierEnterpriseId, id)
                .eq(BizSupplierAccessBasicInformation::getIsDele, "0"));
        vo.setBasicInformationFlag1(count1 > 0 ? "1" : "0");
        vo.setBasicInformationFlag2(count1 > 0 ? "1" : "0");

        //人员信息
        if ("0".equals(vo.getAccessPersonnelFlag())){
            int count2 = accessEnterprisePersonnelManager.count(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel>()
                    .eq(BizSupplierAccessEnterprisePersonnel::getSupplierEnterpriseId, id)
                    .eq(BizSupplierAccessEnterprisePersonnel::getIsDele, "0"));
            vo.setAccessPersonnelFlag(count2 > 0 ? "1" : "0");
        }
        //企业资质
        if ("0".equals(vo.getQualificationFlag())){
            int count3 = enterpriseQualificationDatabaseManager.count(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase>()
                    .eq(BizSupplierEnterpriseQualificationDatabase::getSupplierEnterpriseId, id)
                    .eq(BizSupplierEnterpriseQualificationDatabase::getIsDele, "0"));
            vo.setQualificationFlag(count3 > 0 ? "1" : "0");
        }

        //主营产品情况
        if ("0".equals(vo.getMainProductsSalesStatusFlag())){
            int count4 = mainProductsSalesStatusManager.count(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus>()
                    .eq(BizSupplierMainProductsSalesStatus::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainProductsSalesStatus::getIsDele, "0"));
            vo.setMainProductsSalesStatusFlag(count4 > 0 ? "1" : "0");
        }

        //主营产品质量业绩
        if ("0".equals(vo.getMainProductsPerformanceFlag())){
            int count5 = mainProductsPerformanceManager.count(new LambdaQueryWrapper<BizSupplierMainProductsPerformance>()
                    .eq(BizSupplierMainProductsPerformance::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainProductsPerformance::getIsDele, "0"));
            vo.setMainProductsPerformanceFlag(count5 > 0 ? "1" : "0");
        }

        //主要原材料及供应商
        if ("0".equals(vo.getMainRawMaterialsSuppliersFlag())){
            int count6 = mainRawMaterialsSuppliersManager.count(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers>()
                    .eq(BizSupplierMainRawMaterialsSuppliers::getSupplierEnterpriseId, id)
                    .eq(BizSupplierMainRawMaterialsSuppliers::getIsDele, "0"));
            vo.setMainRawMaterialsSuppliersFlag(count6 > 0 ? "1" : "0");
        }

        //生产制造过程绩效
        if ("0".equals(vo.getProductionProcessPerformanceFlag())){
            int count7 = productionProcessPerformanceManager.count(new LambdaQueryWrapper<BizSupplierProductionProcessPerformance>()
                    .eq(BizSupplierProductionProcessPerformance::getSupplierEnterpriseId, id)
                    .eq(BizSupplierProductionProcessPerformance::getIsDele, "0"));
            vo.setProductionProcessPerformanceFlag(count7 > 0 ? "1" : "0");
        }

        //生产设备
        if ("0".equals(vo.getProductionEquipmentFlag())){
            int count8 = productionEquipmentManager.count(new LambdaQueryWrapper<BizSupplierProductionEquipment>()
                    .eq(BizSupplierProductionEquipment::getSupplierEnterpriseId, id)
                    .eq(BizSupplierProductionEquipment::getIsDele, "0"));
            vo.setProductionEquipmentFlag(count8 > 0 ? "1" : "0");
        }

        //检验设备
        if ("0".equals(vo.getInspectionEquipmentFlag())){
            int count9 = inspectionEquipmentManager.count(new LambdaQueryWrapper<BizSupplierInspectionEquipment>()
                    .eq(BizSupplierInspectionEquipment::getSupplierEnterpriseId, id)
                    .eq(BizSupplierInspectionEquipment::getIsDele, "0"));
            vo.setInspectionEquipmentFlag(count9 > 0 ? "1" : "0");
        }

        //其他特别说明
        if ("0".equals(vo.getOtherSpecialNotesFlag())){
            int count10 = otherSpecialNotesManager.count(new LambdaQueryWrapper<BizSupplierOtherSpecialNotes>()
                    .eq(BizSupplierOtherSpecialNotes::getSupplierEnterpriseId, id)
                    .eq(BizSupplierOtherSpecialNotes::getIsDele, "0"));
            vo.setOtherSpecialNotesFlag(count10 > 0 ? "1" : "0");
        }

        return vo;
    }

    @Override
    public boolean importEnterprise(List<BizSupplierEnterprise> list) {
        for (BizSupplierEnterprise supplierEnterprise : list) {
            String enterpriseName = supplierEnterprise.getEnterpriseName();
            String supplierName = supplierEnterprise.getSupplierName();
            BizEnterprise enterprise = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                    .eq(BizEnterprise::getCompanyName, enterpriseName)
                    .eq(BizEnterprise::getIsDele, "0"));
            BizEnterprise supplier = enterpriseManager.getOne(new LambdaQueryWrapper<BizEnterprise>()
                    .eq(BizEnterprise::getCompanyName, supplierName)
                    .eq(BizEnterprise::getIsDele, "0"));
            supplierEnterprise.setEnterpriseId(enterprise.getOrgId());
            supplierEnterprise.setEnterpriseCode(enterprise.getCompanyCode());
            supplierEnterprise.setSupplierId(supplier.getOrgId());
            supplierEnterprise.setSupplierCode(supplier.getCompanyCode());
            supplierEnterprise.setType("1");
            supplierEnterprise.setCreateMethod("1");
            BizSupplierCategoryConfiguration categoryConfiguration = categoryConfigurationManager.getOne(new LambdaQueryWrapper<BizSupplierCategoryConfiguration>()
                    .eq(BizSupplierCategoryConfiguration::getName, "C类供应商")
                    .eq(BizSupplierCategoryConfiguration::getIsDele,"0"));

            BizSupplierGradingConfiguration gradingConfiguration = gradingConfigurationManager.getOne(new LambdaQueryWrapper<BizSupplierGradingConfiguration>()
                    .eq(BizSupplierGradingConfiguration::getName, "一般供应商")
                    .eq(BizSupplierGradingConfiguration::getIsDele, "0"));
            supplierEnterprise.setCatId(categoryConfiguration.getId());
            supplierEnterprise.setCatName(categoryConfiguration.getName());
            supplierEnterprise.setCatNo(categoryConfiguration.getCode());

            supplierEnterprise.setGradingId(gradingConfiguration.getId());
            supplierEnterprise.setGradingName(gradingConfiguration.getName());
            supplierEnterprise.setGradingNo(gradingConfiguration.getCode());

            String totalAmount = enterpriseAccessManager.selectTotalAmount(supplierEnterprise.getSupplierId());
            supplierEnterprise.setTotalAmount(totalAmount);
        }
        return saveBatch(list);
    }

    private FillingProgressVo createFillingProgress(String id){
        FillingProgressVo vo = new FillingProgressVo();
        BizSupplierEnterprise enterprise = get(id);
        if (BeanUtils.isEmpty(enterprise)){
            return vo;
        }
        BizSupplierEnterpriseAccess enterpriseAccess = enterpriseAccessManager.get(enterprise.getSupplierEnterpriseAccessId());
        if (BeanUtils.isEmpty(enterpriseAccess)){
            return vo;
        }
        BizSupplierAccessBasic accessBasic = accessBasicManager.getOne(new LambdaQueryWrapper<BizSupplierAccessBasic>()
                .eq(BizSupplierAccessBasic::getSupplierAccessId, enterpriseAccess.getAccessConfigurationId())
                .eq(BizSupplierAccessBasic::getIsDele, "0"));
        String code = accessBasic.getCode();
        List<String> modelCode = Arrays.stream(code.split(",")).collect(Collectors.toList());
        //基本情况
        if (modelCode.contains("1")){
            vo.setBasicInformationFlag1("0");
        }
        //人员信息
        if (modelCode.contains("2")){
            vo.setAccessPersonnelFlag("0");
        }
        //企业规模
        if (modelCode.contains("3")){
            vo.setBasicInformationFlag2("0");
        }
        //企业资质
        if (modelCode.contains("4")){
            vo.setQualificationFlag("0");
        }
        //主营产品情况
        if (modelCode.contains("5")){
            vo.setMainProductsSalesStatusFlag("0");
        }
        //主营产品质量业绩
        if (modelCode.contains("6")){
            vo.setMainProductsPerformanceFlag("0");
        }
        //主要原材料及供应商
        if (modelCode.contains("7")){
            vo.setMainRawMaterialsSuppliersFlag("0");
        }
        //生产过程绩效
        if (modelCode.contains("8")){
            vo.setProductionProcessPerformanceFlag("0");
        }
        //主要生产设备
        if (modelCode.contains("9")){
            vo.setProductionEquipmentFlag("0");
        }
        //主要检验设备
        if (modelCode.contains("10")){
            vo.setInspectionEquipmentFlag("0");
        }
        //其他特别说明
        if (modelCode.contains("11")){
            vo.setOtherSpecialNotesFlag("0");
        }
        return vo;
    }

    /**
     * 人员信息 todo
     * @param dto
     * @return
     */
    private Boolean saveOrUpdateAccessPersonel(EnterpriseDto dto) {
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        accessEnterprisePersonnelManager.remove(new LambdaQueryWrapper<BizSupplierAccessEnterprisePersonnel>()
                .eq(BizSupplierAccessEnterprisePersonnel::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierAccessEnterprisePersonnel::getIsDele,"0"));

        //保存新数据
        List<BizSupplierAccessEnterprisePersonnel> personnelList = dto.getEnterprisePersonnelList();
        personnelList.forEach(p -> {
            p.setSupplierEnterpriseId(dto.getId());
            p.setIsDele("0");
            p.setId(null);
        });
        accessEnterprisePersonnelManager.saveBatch(personnelList);
        return true;
    }

    /**
     * 基本情况 企业规模
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateBasicInformation(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierAccessBasicInformation information = dto.getInformation();
        information.setSupplierEnterpriseId(supplierEnterpriseId);
        if (BeanUtils.isEmpty(information.getId())){
            informationManager.save(information);
        }
        else {
            informationManager.updateById(information);
        }
        dto.setInformation(information);
        return true;
    }

    /**
     * 企业资质
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateQualification(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //验证必填资质
//        validateQualification(dto);
        //删除旧数据
        enterpriseQualificationDatabaseManager.remove(new LambdaQueryWrapper<BizSupplierEnterpriseQualificationDatabase>()
                .eq(BizSupplierEnterpriseQualificationDatabase::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierEnterpriseQualificationDatabase::getIsDele,"0"));

        //保存新数据
        Map<String, List<BizSupplierEnterpriseQualificationDatabase>> qualificationMap = dto.getQualificationMap();
        if (BeanUtils.isEmpty(qualificationMap)){
            return true;
        }
        Set<String> keySet = qualificationMap.keySet();
        List<BizSupplierEnterpriseQualificationDatabase> qualificationList = new ArrayList<>();
        for (String key : keySet) {
            qualificationList.addAll(qualificationMap.get(key));
        }
        qualificationList.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            q.setEnterpriseId(dto.getSupplierId());
            q.setEnterpriseCode(dto.getSupplierCode());
            q.setId(null);
        });
        enterpriseQualificationDatabaseManager.saveBatch(qualificationList);
        return true;
    }

//    private void validateQualification(EnterpriseAccess2Dto dto){
//        Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap = dto.getQualificationMap();
//
//        //表单提交的资质类型
//        List<BizSupplierEnterpriseQualificationDatabase2> qualification = qualificationMap.get("accessQualifications");
//        Set<String> catNameSet = qualification.stream().map(q -> q.getQualificationCategoryName()).collect(Collectors.toSet());
//        List<String> catNameList = catNameSet.stream().collect(Collectors.toList());
//
//        //供应商配置的资质类型
//        List<BizSupplierQualificationDatabase> qualificationDatabaseList = qualificationDatabaseManager.listByCategoryCode(null,dto.getSupplierId());
//        List<String> supCatNameList = qualificationDatabaseList.stream().map(q -> q.getQualificationCategoryName()).collect(Collectors.toList());
//        //供应商未配置的资质类型
////        List<String> subtractCatNameList = CollectionUtil.subtractToList(supCatNameList, catNameList);
//        for (String s : supCatNameList) {
//            catNameList.remove(s);
//        }
//        if (BeanUtils.isNotEmpty(catNameList) && catNameList.size() > 0){
//            String subtractCatName = String.join(",", catNameList);
//            throw new ApplicationException("请配置" + "【" + subtractCatName + "】类型的资质！");
//        }
//    }

    /**
     * 主营产品情况
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainProductsSalesStatus(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();

        mainProductsSalesStatusManager.remove(new LambdaQueryWrapper<BizSupplierMainProductsSalesStatus>()
                .eq(BizSupplierMainProductsSalesStatus::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierMainProductsSalesStatus::getIsDele,"0"));


        //主营产品情况
        List<BizSupplierMainProductsSalesStatus> salesStatusList = dto.getSalesStatusList();
        if (BeanUtils.isEmpty(salesStatusList)){
            return true;
        }
        salesStatusList.forEach(s -> {
            s.setSupplierEnterpriseId(supplierEnterpriseId);
            s.setId(null);
        });
        mainProductsSalesStatusManager.saveBatch(salesStatusList);

        return true;
    }

    /**
     * 主要原材料及供应商
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainRawMaterialsSuppliers(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        mainRawMaterialsSuppliersManager.remove(new LambdaQueryWrapper<BizSupplierMainRawMaterialsSuppliers>()
                .eq(BizSupplierMainRawMaterialsSuppliers::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierMainRawMaterialsSuppliers::getIsDele,"0"));

        //保存新数据
        List<BizSupplierMainRawMaterialsSuppliers> rawMaterialsSuppliersList = dto.getRawMaterialsSuppliersList();
        if (BeanUtils.isEmpty(rawMaterialsSuppliersList)){
            return true;
        }
        rawMaterialsSuppliersList.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            q.setId(null);
        });
        mainRawMaterialsSuppliersManager.saveBatch(rawMaterialsSuppliersList);
        return true;
    }

    /**
     * 生产制造过程绩效
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateProductionProcessPerformance(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierProductionProcessPerformanceDto processPerformance = dto.getProcessPerformance();
        if (BeanUtils.isEmpty(processPerformance)){
            return true;
        }
        processPerformance.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(processPerformance.getId())){
            productionProcessPerformanceManager.save(processPerformance);
        }
        //修改
        else {
            productionProcessPerformanceManager.updateById(processPerformance);
            //删除旧的生产工艺流程
            productionProcessFlowManager.remove(new LambdaQueryWrapper<BizSupplierProductionProcessFlow>()
                    .eq(BizSupplierProductionProcessFlow::getSupplierProductionProcessPerformanceId,processPerformance.getId())
                    .eq(BizSupplierProductionProcessFlow::getIsDele,"0"));
        }
        //保存新的生产工艺流程
        List<BizSupplierProductionProcessFlow> processFlowList = processPerformance.getProcessFlowList();
        processFlowList.forEach(p -> {
            p.setSupplierProductionProcessPerformanceId(processPerformance.getId());
            p.setId(null);
        });
        productionProcessFlowManager.saveBatch(processFlowList);
        //保存附件
        List<DefaultFile> files = processPerformance.getFiles();
        if (files != null && files.size() > 0){
            for (DefaultFile file : files) {
                file.setId(null);
                file.setBizId(processPerformance.getId());
            }
            fileManager.saveBatch(files);
        }
        dto.setProcessPerformance(processPerformance);
        return true;
    }

    /**
     * 主要生产设备
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateProductionEquipment(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        productionEquipmentManager.remove(new LambdaQueryWrapper<BizSupplierProductionEquipment>()
                .eq(BizSupplierProductionEquipment::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierProductionEquipment::getIsDele,"0"));
        //保存新数据
        List<BizSupplierProductionEquipment> productionEquipmentList = dto.getProductionEquipmentList();
        if (BeanUtils.isEmpty(productionEquipmentList)){
            return true;
        }
        productionEquipmentList.forEach(e -> {
            e.setSupplierEnterpriseId(supplierEnterpriseId);
            e.setId(null);
        });
        //保存附件
        List<DefaultFile> files = dto.getProductionEquipmentFiles();
        if (files != null && files.size() > 0){
            for (DefaultFile file : files) {
                file.setId(null);
                file.setBizId(supplierEnterpriseId);
            }
            fileManager.saveBatch(files);
        }
        productionEquipmentManager.saveBatch(productionEquipmentList);
        return true;
    }

    /**
     * 主要检验设备
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateInspectionEquipment(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        //删除旧数据
        inspectionEquipmentManager.remove(new LambdaQueryWrapper<BizSupplierInspectionEquipment>()
                .eq(BizSupplierInspectionEquipment::getSupplierEnterpriseId,supplierEnterpriseId)
                .eq(BizSupplierInspectionEquipment::getIsDele,"0"));
        //保存新数据
        List<BizSupplierInspectionEquipment> inspectionEquipmentList = dto.getInspectionEquipmentList();
        if (BeanUtils.isEmpty(inspectionEquipmentList)){
            return true;
        }
        inspectionEquipmentList.forEach(e -> {
            e.setSupplierEnterpriseId(supplierEnterpriseId);
            e.setId(null);
        });
        //保存附件
        List<DefaultFile> files = dto.getInspectionEquipmentFiles();
        if (files != null && files.size() > 0){
            for (DefaultFile file : files) {
                file.setId(null);
                file.setBizId(supplierEnterpriseId);
            }
            fileManager.saveBatch(files);
        }
        inspectionEquipmentManager.saveBatch(inspectionEquipmentList);
        return true;
    }

    /**
     * 其他特别说明
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateOtherSpecialNotes(EnterpriseDto dto){
        Boolean result = false;
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierOtherSpecialNotes otherSpecialNotes = dto.getOtherSpecialNotes();
        if (BeanUtils.isEmpty(otherSpecialNotes)){
            return true;
        }
        otherSpecialNotes.setSupplierEnterpriseId(supplierEnterpriseId);
        if (BeanUtils.isEmpty(otherSpecialNotes.getId())){
            result = otherSpecialNotesManager.save(otherSpecialNotes);
        }
        else {
            result = otherSpecialNotesManager.updateById(otherSpecialNotes);
        }
//        保存附件
        List<DefaultFile> files = otherSpecialNotes.getFiles();
        if (files != null && files.size() > 0){
            for (DefaultFile file : files) {
                file.setId(null);
                file.setBizId(otherSpecialNotes.getId());
            }
            fileManager.saveBatch(files);
        }
        dto.setOtherSpecialNotes(otherSpecialNotes);
        return result;
    }

    /**
     * 现场评审
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewRatingDetails(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        Map<String, List<BizSupplierReviewRatingDetailsDto>> reviewRatingDetailsMap = dto.getReviewRatingDetailsMap();
        if (BeanUtils.isEmpty(reviewRatingDetailsMap)){
            return true;
        }
        Set<String> keySet = reviewRatingDetailsMap.keySet();
        List<BizSupplierReviewRatingDetailsDto> reviewRatingDetailsList = new ArrayList<>();
        for (String key : keySet) {
            reviewRatingDetailsList.addAll(reviewRatingDetailsMap.get(key));
        }
        //需评审成员
        Set<String> rpSet = new HashSet<>();
        reviewRatingDetailsList.forEach(q -> {
            q.setSupplierEnterpriseId(supplierEnterpriseId);
            if (BeanUtils.isNotEmpty(q.getId())){
                reviewRatingDetailsManager.updateById(q);
            }else {
                reviewRatingDetailsManager.save(q);
            }
            List<BizSupplierReviewRatingPanel> panelList = q.getPanelList();
            panelList.forEach(p -> {
                p.setReviewRatingDetailsId(q.getId());
                if (BeanUtils.isNotEmpty(p.getId())){
                    reviewRatingPanelManager.updateById(p);
                }else {
                    rpSet.add(p.getRatingId());
                    reviewRatingPanelManager.save(p);
                }
            });
        });
        return true;
    }

    /**
     * 评定报告
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewReport(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierReviewReportDto reviewReport = dto.getReviewReport();
        if (BeanUtils.isEmpty(reviewReport)){
            return true;
        }
        reviewReport.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(reviewReport.getId())){
            reviewReportManager.save(reviewReport);
        }
        //修改
        else {
            reviewReportManager.updateById(reviewReport);
            //删除旧的评审成员
            reviewReportPanelManager.remove(new LambdaQueryWrapper<BizSupplierReviewReportPanel>()
                    .eq(BizSupplierReviewReportPanel::getReviewReportId,reviewReport.getId())
                    .eq(BizSupplierReviewReportPanel::getIsDele,"0"));
        }
        //保存新的评审成员
        List<BizSupplierReviewReportPanel> reportPanelList = reviewReport.getPanelList();
        reportPanelList.forEach(p -> {
            p.setReviewReportId(reviewReport.getId());
            p.setId(null);
        });
        reviewReportPanelManager.saveBatch(reportPanelList);
        dto.setReviewReport(reviewReport);
        return true;
    }

    /**
     * 试生产评审
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateReviewTrialReport(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        BizSupplierReviewTrialReportDto reviewTrialReport = dto.getReviewTrialReport();
        if (BeanUtils.isEmpty(reviewTrialReport)){
            return true;
        }
        reviewTrialReport.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(reviewTrialReport.getId())){
            reviewTrialReportManager.save(reviewTrialReport);
        }
        //修改
        else {
            reviewTrialReportManager.updateById(reviewTrialReport);
            //删除旧的评审成员
            reviewTrialReportPanelManager.remove(new LambdaQueryWrapper<BizSupplierReviewTrialReportPanel>()
                    .eq(BizSupplierReviewTrialReportPanel::getReviewReportId,reviewTrialReport.getId())
                    .eq(BizSupplierReviewTrialReportPanel::getIsDele,"0"));
        }
        //保存新的评审成员
        List<BizSupplierReviewTrialReportPanel> panelList = reviewTrialReport.getPanelList();
        panelList.forEach(p -> {
            p.setReviewReportId(reviewTrialReport.getId());
            p.setId(null);
        });
        reviewTrialReportPanelManager.saveBatch(panelList);
        dto.setReviewTrialReport(reviewTrialReport);
        return true;
    }

    /**
     * 主营产品情况及质量业绩
     * @param dto
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public Boolean saveOrUpdateMainProductsPerformance(EnterpriseDto dto){
        //供应商准入ID
        String supplierEnterpriseId = dto.getId();
        MainProductsPerformanceDto mainProductsPerformance = dto.getMainProductsPerformance();
        if (BeanUtils.isEmpty(mainProductsPerformance)){
            return true;
        }
        String supplierMainProductsPerformanceId = mainProductsPerformance.getId();
        mainProductsPerformance.setSupplierEnterpriseId(supplierEnterpriseId);
        //保存
        if (BeanUtils.isEmpty(supplierMainProductsPerformanceId)){
            //主营产品主表
            mainProductsPerformanceManager.save(mainProductsPerformance);
        }
        //修改
        else {
            //主营产品主表
            mainProductsPerformanceManager.updateById(mainProductsPerformance);
            //删除旧的子表数据
            mainProductsQualityPerformanceManager.remove(new LambdaQueryWrapper<BizSupplierMainProductsQualityPerformance>()
                    .eq(BizSupplierMainProductsQualityPerformance::getSupplierMainProductsPerformanceId,supplierMainProductsPerformanceId)
                    .eq(BizSupplierMainProductsQualityPerformance::getIsDele,"0"));
            mainProductsPerformanceCustomerComplaintsManager.remove(new LambdaQueryWrapper<BizSupplierMainProductsPerformanceCustomerComplaints>()
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints::getSupplierMainProductsPerformanceId,supplierMainProductsPerformanceId)
                    .eq(BizSupplierMainProductsPerformanceCustomerComplaints::getIsDele,"0"));
        }
        //主营产品质量表现
        List<BizSupplierMainProductsQualityPerformance> qualityPerformanceList = mainProductsPerformance.getQualityPerformanceList();
        qualityPerformanceList.forEach(q -> {
            q.setSupplierMainProductsPerformanceId(mainProductsPerformance.getId());
            q.setId(null);
        });
        mainProductsQualityPerformanceManager.saveBatch(qualityPerformanceList);
        //客户抱怨（上年度）
        List<BizSupplierMainProductsPerformanceCustomerComplaints> customerComplaintsList = mainProductsPerformance.getCustomerComplaintsList();
        customerComplaintsList.forEach(c -> {
            c.setSupplierMainProductsPerformanceId(mainProductsPerformance.getId());
            c.setId(null);
        });
        mainProductsPerformanceCustomerComplaintsManager.saveBatch(customerComplaintsList);

        //保存附件
        List<DefaultFile> files = mainProductsPerformance.getFiles();
        if (files != null && files.size() > 0){
            for (DefaultFile file : files) {
                file.setId(null);
                file.setBizId(mainProductsPerformance.getId());
            }
            fileManager.saveBatch(files);
        }
        dto.setMainProductsPerformance(mainProductsPerformance);
        return true;
    }
}
