package com.artfess.gyl.supplierAccess.model;

import com.artfess.base.entity.AutoFillFullModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商准入-基本情况调查配置表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-11-07
 */
@Data
@ApiModel(value="BizSupplierAccessBasic对象", description="供应商准入-基本情况调查配置表")
public class BizSupplierAccessBasic extends AutoFillFullModel<BizSupplierAccessBasic> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "准入配置ID")
    @TableField("SUPPLIER_ACCESS_ID_")
    private String supplierAccessId;

    @ApiModelProperty(value = "配置编码（1：基本情况，2：企业规模，3：企业资质，4：主营产品情况及质量业绩，5：主要原材料及供应商6：生产制造过程绩效7：生产及检验设备8：其他特别说明）")
    @TableField("CODE_")
    private String code;

    @ApiModelProperty(value = "配置名称")
    @TableField("NAME_")
    private String name;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;
}
