package com.artfess.gyl.ecologyOa.controller;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.gyl.ecologyOa.manager.EcologyOaManager;
import com.artfess.base.model.CommonResult;
import com.artfess.gyl.ecologyOa.vo.CreateWorkVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:泛微OA系统接口
 * @Author: Rong Tao
 * @Date: 2025/8/5 16:01
 */
@RestController
@Api(tags = "泛微OA系统接口")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
@RequestMapping("ecologyOa")
public class EcologyOaController {

    @Value("${ecologyOa.getToDoWorkListUrl}")
    private String getToDoWorkListUrl;
    @Value("${ecologyOa.getHandledWorkListUrl}")
    private String getHandledWorkListUrl;
    @Value("${ecologyOa.getRequestWorkListUrl}")
    private String getRequestWorkListUrl;

    @Autowired
    private EcologyOaManager ecologyOaManager;

    @PostMapping("/getToken")
    @ApiOperation(value = "M-获取泛微token")
    public CommonResult getToken() {
        String token = ecologyOaManager.getToken();
        return new CommonResult(true,"操作成功",token);
    }

    @PostMapping("/getOaUserId")
    @ApiOperation(value = "M-获取当前用户泛微用户id")
    public CommonResult getOaUserId() {
        String mobile = ContextUtil.getCurrentUser().getMobile();
        String userId = ecologyOaManager.getOaUserId(mobile);
        return new CommonResult(true,"操作成功",userId);
    }

    @PostMapping("/getTaskCount")
    @ApiOperation(value = "M-获取当前用户待办数量")
    public CommonResult getTaskCount() {
        Integer count = ecologyOaManager.getTaskCount();
        return new CommonResult(true,"操作成功",count);
    }

    @PostMapping("/getToDoWorkList")
    @ApiOperation(value = "M-获取当前用户待办列表")
    public CommonResult getToDoWorkList() {
        JSONArray result = ecologyOaManager.getWorkList(getToDoWorkListUrl);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/getHandledWorkList")
    @ApiOperation(value = "M-获取当前用户已办列表")
    public CommonResult getHandledWorkList() {
        JSONArray result = ecologyOaManager.getWorkList(getHandledWorkListUrl);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/getRequestWorkList")
    @ApiOperation(value = "M-获取当前用户请求列表")
    public CommonResult getRequestWorkList() {
        JSONArray result = ecologyOaManager.getWorkList(getRequestWorkListUrl);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/createWork")
    @ApiOperation(value = "M-创建流程")
    public JSONObject createWork(@RequestBody CreateWorkVo createWorkVo) {
        JSONObject result = ecologyOaManager.createWork(createWorkVo,null);
        return result;
    }

    @PostMapping("/getSsoToken")
    @ApiOperation(value = "M-获取ssoToken")
    public CommonResult getSsoToken() {
        String result = ecologyOaManager.getSsoToken();
        return new CommonResult(true,"操作成功",result);
    }

}
