package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.*;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;

import java.time.LocalDateTime;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 物资分类&基本物料分类关联表
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Data
@TableName("BIZ_SUPPLIER_MATERIAL_CATEGORY_DETAILS")
@ApiModel(value="BizSupplierMaterialCategoryDetails对象", description="物资分类&基本物料分类关联表")
public class BizSupplierMaterialCategoryDetails extends BizDelModel<BizSupplierMaterialCategoryDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "企业ID")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "物资分类ID")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_ID_")
    private String supplierMaterialCategoryId;

    @ApiModelProperty(value = "物资分类CODE")
    @TableField("SUPPLIER_MATERIAL_CATEGORY_CODE_")
    private String supplierMaterialCategoryCode;

    @ApiModelProperty(value = "基础物料分类ID")
    @TableField("CATEGORY_ID_")
    private String categoryId;

    @ApiModelProperty(value = "基础物料分类编号")
    @TableField("CATEGORY_PLATCODE_")
    private String categoryPlatcode;

    @ApiModelProperty(value = "排序号")
    @TableField("SEQ_")
    private Integer seq;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField(value="CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人组织Id")
    @TableField(value="CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField(value="CREATE_DEPT_ID_",select=false)
    private String createDeptId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField(value="CREATE_DEPT_NAME_", select=false)
    private String createDeptName;

    @ApiModelProperty(value = "创建人姓名")
    @TableField(value="CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "更新人姓名")
    @TableField(value="UPDATE_NAME_", select=false)
    private String updateName;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField(value="UPDATE_ORG_ID_",select=false)
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField(value="UPDATE_ORG_NAME_",select=false)
    private String updateOrgName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField(value="UPDATE_DEPT_ID_", select=false)
    private String updateDeptId;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField(value="UPDATE_DEPT_NAME_", select=false)
    private String updateDeptName;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField(value="LAST_TIME_", select=false)
    private Long lastTime;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_")
    @TableLogic
    private String isDele="0";

    @ApiModelProperty(value = "版本号")
    @TableField(value ="VERSION_")
    private Long version=1L;

    @ApiModelProperty(value = "租户ID")
    @TableField(value ="TENANT_ID_")
    private String tenantId="-1";
}
