package com.artfess.gyl.base.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 电子合同回调记录表
 *
 * @author 管理员
 * @since 2025-12-10
 */
@Data
@TableName("biz_contract_callback")
@ApiModel(value="BizContractCallback对象", description="电子合同回调记录表")
public class BizContractCallback extends BizDelModel<BizContractCallback> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "文件编号（第三方合同id）")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "文件自定义编号")
    @TableField("SN_")
    private String sn;

    @ApiModelProperty(value = "文件状态（DRAFT：草稿，FILLING：拟定中，SIGNING：签署中，COMPLETE：已完成，REJECTED：已退回，RECALLED：已撤回，EXPIRED：已过期，TERMINATING：作废中，TERMINATED：已作废，DELETE：已删除，FINISHED：强制完成）")
    @TableField("STATUS_")
    private String status;

    @ApiModelProperty(value = "回调类型")
    @TableField("TYPE_")
    private String type;

    @ApiModelProperty(value = "联系方式")
    @TableField("CONTACT")
    private String contact;

    @ApiModelProperty(value = "操作人姓名")
    @TableField("OPERATOR_NAME_")
    private String operatorName;

    @ApiModelProperty(value = "操作人手机号")
    @TableField("OPERATOR_MOBILE_")
    private String operatorMobile;

    @ApiModelProperty(value = "操作人员工编号")
    @TableField("OPERATOR_NUMBER_")
    private String operatorNumber;

    @ApiModelProperty(value = "经办人员工编号")
    @TableField("RECEIVDER_NUMBER_")
    private String receivderNumber;

    @ApiModelProperty(value = "ak")
    @TableField("ACCESSKEY_")
    private String accesskey;

    @ApiModelProperty(value = "sk")
    @TableField("SECRETKEY_")
    private String secretkey;

    @ApiModelProperty(value = "调用结果（1：成功，2：失败）")
    @TableField("RESULT_")
    private Integer result;

    public BizContractCallback(){

    }

    public BizContractCallback(String contractId, String sn, String status, String type, String contact, String operatorName, String operatorMobile, String operatorNumber, String receivderNumber, String accesskey, String secretkey, Integer result) {
        this.contractId = contractId;
        this.sn = sn;
        this.status = status;
        this.type = type;
        this.contact = contact;
        this.operatorName = operatorName;
        this.operatorMobile = operatorMobile;
        this.operatorNumber = operatorNumber;
        this.receivderNumber = receivderNumber;
        this.accesskey = accesskey;
        this.secretkey = secretkey;
        this.result = result;
    }
}
