package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.gyl.base.manager.BizSupplierGradingSupplyScopeManager;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.dao.BizSupplierGradingConfigurationDao;
import com.artfess.gyl.base.manager.BizSupplierGradingConfigurationManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.base.model.BizSupplierGradingSupplyScope;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

/**
 * 供应商分级管理表 服务实现类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@Service
public class BizSupplierGradingConfigurationManagerImpl extends BaseManagerImpl<BizSupplierGradingConfigurationDao, BizSupplierGradingConfiguration> implements BizSupplierGradingConfigurationManager {

    @Resource
    private SysIdentityManager sysIdentityManager;

    @Resource
    private BizSupplierGradingSupplyScopeManager scopeManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizSupplierGradingConfiguration entity){

        Asserts.notNull(entity.getScopes(),"明细不能为空");

        String no = sysIdentityManager.nextId("gysfjbm");
        entity.setCode(no);
        if(StringUtil.isEmpty(entity.getStatus())){
            entity.setStatus("1");
        }
        boolean save = super.save(entity);
        if (!save){
            return false;
        }
        List<BizSupplierGradingSupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        scopes.forEach(s->{
            s.setId(null);
            s.setSupplierGradingConfigurationId(id);
        });
        if (!scopeManager.saveBatch(scopes)){
            throw new ApplicationException("分类关联失败");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizSupplierGradingConfiguration entity) {

        Asserts.notNull(entity.getScopes(),"明细不能为空");

        boolean update = super.updateById(entity);
        if (!update){
            return false;
        }
        List<BizSupplierGradingSupplyScope> scopes = entity.getScopes();
        String id = entity.getId();
        //删除之前数据
        LambdaQueryWrapper<BizSupplierGradingSupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierGradingSupplyScope>()
                .eq(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, id);
        scopeManager.remove(wrapper);
        scopes.forEach(s->{
            s.setId(null);
            s.setSupplierGradingConfigurationId(id);
        });
        if (!scopeManager.saveBatch(scopes)){
            throw new ApplicationException("分类关联失败");
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        //删除关联数据
        LambdaQueryWrapper<BizSupplierGradingSupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierGradingSupplyScope>()
                .in(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, idList);
        scopeManager.remove(wrapper);
        //删除主表数据
        return super.removeByIds(idList);
    }

    @Override
    @Transactional(readOnly = true)
    public BizSupplierGradingConfiguration getById(Serializable id) {
        BizSupplierGradingConfiguration entity = super.getById(id);
        //查询关联明细
        LambdaQueryWrapper<BizSupplierGradingSupplyScope> wrapper = new LambdaQueryWrapper<BizSupplierGradingSupplyScope>()
                .eq(BizSupplierGradingSupplyScope::getSupplierGradingConfigurationId, entity.getId());
        List<BizSupplierGradingSupplyScope> scopes = scopeManager.list(wrapper);
        if (!CollectionUtils.isEmpty(scopes)){
            entity.setScopes(scopes);
        }
        return entity;
    }

    @Override
    public boolean updateStatusById(String id, String status) {
        LambdaUpdateWrapper<BizSupplierGradingConfiguration> wrapper = new LambdaUpdateWrapper<>();
        wrapper.eq(BizSupplierGradingConfiguration::getId, id);
        wrapper.set(BizSupplierGradingConfiguration::getStatus, status);
        return this.update(wrapper);
    }

    @Override
    public PageList<BizSupplierGradingConfiguration> queryByPage(QueryFilter<BizSupplierGradingConfiguration> queryFilter) {
        IPage<BizSupplierGradingConfiguration> iPage = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(iPage);
    }

    @Override
    public BizSupplierGradingConfiguration getByCategoryConfiguration(String categoryConfigurationId) {
        return baseMapper.getByCategoryConfiguration(categoryConfigurationId);
    }
}
