package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.model.BizEnterprisePersonnel;
import com.artfess.gyl.base.dao.BizEnterprisePersonnelDao;
import com.artfess.gyl.base.manager.BizEnterprisePersonnelManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.uc.api.impl.util.ContextUtil;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 企业人员管理 服务实现类
 *
 * @author huqi
 * @since 2025-11-21
 */
@Service
public class BizEnterprisePersonnelManagerImpl extends BaseManagerImpl<BizEnterprisePersonnelDao, BizEnterprisePersonnel> implements BizEnterprisePersonnelManager {

    @Resource
    private FileManager fileManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizEnterprisePersonnel entity){
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if(!super.save(entity)){
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if (files != null && files.size() > 0) {
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizEnterprisePersonnel entity){
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if(!super.updateById(entity)){
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if (files != null && files.size() > 0) {
            //先删除不在此次列表的数据
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.removeFileByBizId(entity.getId(),fileIds);
            //更新附件
            fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        }else {
            fileManager.removeFileByBizId(entity.getId(),null);
        }
        return true;
    }

    @Override
    public BizEnterprisePersonnel getById(Serializable id) {
        BizEnterprisePersonnel entity = super.getById(id);
        if(entity == null){
            return null;
        }
        List<DefaultFile> files = fileManager.queryFileByBizId(entity.getId(), null);
        entity.setFiles(files);
        return entity;
    }
}
