package com.artfess.gyl.base.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.file.model.DefaultFile;
import com.artfess.file.persistence.manager.FileManager;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.dao.BizEnterpriseBusinessLicenseDao;
import com.artfess.gyl.base.manager.BizEnterpriseBusinessLicenseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.apache.http.util.Asserts;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 企业营业执照 服务实现类
 *
 * @author huqi
 * @since 2025-11-21
 */
@Service
public class BizEnterpriseBusinessLicenseManagerImpl extends BaseManagerImpl<BizEnterpriseBusinessLicenseDao, BizEnterpriseBusinessLicense> implements BizEnterpriseBusinessLicenseManager {

    @Resource
    private FileManager fileManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean save(BizEnterpriseBusinessLicense entity){
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.save(entity)){
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        if( files!= null){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            fileManager.updateFileBizIdByIds(fileIds,entity.getId());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(BizEnterpriseBusinessLicense entity){
        if (entity.getTimeLimit() != null && entity.getTimeLimit()==1){
            entity.setSrartBusinessTerm(null);
            entity.setEndBusinessTerm(null);
        }
        entity.setEnterpriseId(ContextUtil.getCurrentOrgId());
        entity.setEnterpriseCode(ContextUtil.getCurrentOrgCode());
        entity.setEnterpriseName(ContextUtil.getCurrentOrgName());
        if (!super.updateById(entity)){
            return false;
        }
        List<DefaultFile> files = entity.getFiles();
        String id = entity.getId();
        if( files!= null && files.size() > 0){
            List<String> fileIds = files.stream().map(DefaultFile::getId).collect(Collectors.toList());
            //删除附件
            fileManager.removeFileByBizId(id,fileIds);
            //修改附件
            fileManager.updateFileBizIdByIds(fileIds,id);
        }else {
            fileManager.removeFileByBizId(id,null);
        }
        return true;
    }

    @Override
    public PageList<BizEnterpriseBusinessLicense> queryBySupplierVersion(QueryFilter<BizEnterpriseBusinessLicense> queryFilter) {
            queryFilter.addFilter("i.IS_DELE_","0", QueryOP.EQUAL);
            queryFilter.addFilter("se.IS_DELE_","0", QueryOP.EQUAL);
            IPage<BizEnterpriseBusinessLicense> iPage = baseMapper.queryBySupplierVersion(convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
            return new PageList<>(iPage);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BizEnterpriseBusinessLicense getModelByOrgId(String orgId) {
        LambdaQueryWrapper<BizEnterpriseBusinessLicense> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(BizEnterpriseBusinessLicense::getEnterpriseId, orgId);
        wrapper.orderByDesc(BizEnterpriseBusinessLicense::getVersion);
        wrapper.last("limit 1");
        BizEnterpriseBusinessLicense entity = super.getOne(wrapper);
        if (entity == null){
            return null;
        }
        //查询附件
        List<DefaultFile> files = fileManager.queryFileByBizId(entity.getId());
        entity.setFiles(files);
        return entity;
    }

    @Override
    @Transactional(readOnly = true)
    public BizEnterpriseBusinessLicense getById(Serializable id) {
        BizEnterpriseBusinessLicense entity = super.getById(id);
        if (entity == null){
            return null;
        }
        //查询附件
        List<DefaultFile> files = fileManager.queryFileByBizId(entity.getId());
        entity.setFiles(files);
        return entity;
    }
}
