package com.artfess.gyl.base.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.base.manager.BaseManager;

/**
 * 供应商分级管理表 服务类
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
public interface BizSupplierGradingConfigurationManager extends BaseManager<BizSupplierGradingConfiguration> {


    /**
     * 根据id修改启用状态
     * @param id
     * @param status
     * @return
     */
    public boolean updateStatusById(String id, String status);

    /**
     * 通用查询
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierGradingConfiguration> queryByPage(QueryFilter<BizSupplierGradingConfiguration> queryFilter);

    /**
     * 合格供应商根据供应商分类查询
     * @param categoryConfigurationId
     * @return
     */
    BizSupplierGradingConfiguration getByCategoryConfiguration(String categoryConfigurationId);
}
