package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizSupplierGradingConfiguration;
import com.artfess.gyl.base.manager.BizSupplierGradingConfigurationManager;

/**
 * 供应商分级管理表 前端控制器
 *
 * @author 系统管理员
 * @since 2025-11-07
 */
@RestController
@RequestMapping("/bizSupplierGradingConfiguration/v1/")
@Api(tags = "供应商分级管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierGradingConfigurationController extends BaseController<BizSupplierGradingConfigurationManager, BizSupplierGradingConfiguration> {

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "根据id修改状态")
    public CommonResult<String> updateStatus(@RequestParam("id")String id, @RequestParam("status")String status) {
        boolean res = baseService.updateStatusById(id, status);
        return new CommonResult(res?"修改成功":"修改失败");
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierGradingConfiguration> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierGradingConfiguration> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        return baseService.queryByPage(queryFilter);
    }

}
