package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.gyl.base.model.BizEnterprisePersonnel;
import com.artfess.gyl.supplierApply3.model.BizSupplierEnterpriseRegisterInformation;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizEnterpriseBusinessLicense;
import com.artfess.gyl.base.manager.BizEnterpriseBusinessLicenseManager;

/**
 * 企业营业执照 前端控制器
 *
 * @author huqi
 * @since 2025-11-21
 */
@Api(tags = "企业营业执照")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
@RestController
@RequestMapping("/bizEnterpriseBusinessLicense/v1/")
public class BizEnterpriseBusinessLicenseController extends BaseController<BizEnterpriseBusinessLicenseManager, BizEnterpriseBusinessLicense> {

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizEnterpriseBusinessLicense> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizEnterpriseBusinessLicense> queryFilter) {
        queryFilter.addFilter("ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.query(queryFilter);
    }

    @PostMapping(value = "/queryBySupplier", produces = {"application/json; charset=utf-8"})
    @ApiOperation("企业查询-合格供应商分页查询结果")
    public PageList<BizEnterpriseBusinessLicense> queryBySupplier(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizEnterpriseBusinessLicense> queryFilter) {
        queryFilter.addFilter("se.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("se.TYPE_",1, QueryOP.EQUAL);
        return baseService.queryBySupplierVersion(queryFilter);
    }

    @GetMapping(value = "/getModel/org")
    @ApiOperation("企业查询-查询资质信息")
    public CommonResult<String> getModelByOrgId() {
        BizEnterpriseBusinessLicense entity = baseService.getModelByOrgId(ContextUtil.getCurrentOrgId());
        return CommonResult.success(entity,"查询成功");
    }
}
