package com.artfess.gyl.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.exception.BaseException;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.qiyuesuo.sdk.bean.contract.ViewUrlRequest;
import net.qiyuesuo.sdk.common.exception.PrivateAppException;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.base.model.BizContract;
import com.artfess.gyl.base.manager.BizContractManager;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 采购合同表 前端控制器
 *
 * @author huqi
 * @since 2025-12-04
 */
@Api(tags = "合同管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
@RestController
@RequestMapping("/bizContract/v1/")
public class BizContractController extends BaseController<BizContractManager, BizContract> {

    @PostMapping("/browseContract")
    @ApiOperation(value = "M-浏览合同")
    public CommonResult browseContract(@ApiParam(name = "threeContrId",value = "第三方合同id") @RequestParam("threeContrId") String threeContrId){
        String viewUrl = baseService.viewContract(threeContrId);
        return new CommonResult(viewUrl);
    }

    @PostMapping("/downBatchContract")
    @ApiOperation(value = "M-批量下载合同")
    public CommonResult downBatchContract(@ApiParam(name = "threeContrIds",value = "第三方合同id集合") @RequestBody List<Long> threeContrIds, HttpServletResponse response){
        baseService.downContract(response, threeContrIds);
        return new CommonResult("下载成功");
    }

}
