/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.Direction;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.AppUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.Dom4jUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JAXBUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.bo.bodef.BoDefService;
import com.artfess.bo.instance.BoDataImportHandler;
import com.artfess.bo.model.BoAttribute;
import com.artfess.bo.model.BoDef;
import com.artfess.bo.model.BoEnt;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormDataTemplate;
import com.artfess.form.model.FormDataTemplateDraft;
import com.artfess.form.model.FormDataTemplateXml;
import com.artfess.form.model.FormDataTemplateXmlList;
import com.artfess.form.model.FormImportCheckJar;
import com.artfess.form.model.FormMeta;
import com.artfess.form.param.BpmDataTemplateInfoVo;
import com.artfess.form.param.DataTemplateQueryVo;
import com.artfess.form.persistence.dao.FormDataTemplateDao;
import com.artfess.form.persistence.manager.FormDataTemplateDraftManager;
import com.artfess.form.persistence.manager.FormDataTemplateManager;
import com.artfess.form.persistence.manager.FormImportCheckJarManager;
import com.artfess.form.persistence.manager.FormManager;
import com.artfess.form.persistence.manager.FormMetaManager;
import com.artfess.form.util.FormUtil;
import com.artfess.form.vo.ExportSubVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.impl.var.IContextVar;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/form/dataTemplate/v1"})
@Api(tags={"\u6570\u636e\u89c6\u56fe\u63a5\u53e3(\u4e1a\u52a1\u6570\u636e\u6a21\u677f)"})
@ApiGroup(group={"group_form"})
public class FormDataTemplateController
extends BaseController<FormDataTemplateManager, FormDataTemplate> {
    @Resource
    BoDefService boDefService;
    @Resource
    FormDataTemplateDao bpmDataTemplateDao;
    @Resource
    FormManager formManager;
    @Resource
    FormMetaManager formMetaManager;
    @Resource
    FormDataTemplateDraftManager dataTemplateDraftManager;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<Map<String, Object>> listJson(@ApiParam(name="queryFilter", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u67e5\u8be2\u5bf9\u8c61") @RequestBody DataTemplateQueryVo dataTemplateQueryVo) throws Exception {
        FormDataTemplate template = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)dataTemplateQueryVo.getTemplateId()));
        return ((FormDataTemplateManager)this.baseService).getList(template, dataTemplateQueryVo);
    }

    @RequestMapping(value={"listToJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<FormDataTemplate> listToJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        queryFilter.setDefaultSort("CREATE_TIME_", Direction.DESC);
        PageList bpmDataTemplates = ((FormDataTemplateManager)this.baseService).query(queryFilter);
        return bpmDataTemplates;
    }

    @RequestMapping(value={"dataList_{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u5217\u8868  \u7b2c\u4e8c\u6b21\u89e3\u6790\u6a21\u677f", httpMethod="POST", notes="\u6570\u636e\u5217\u8868  \u7b2c\u4e8c\u6b21\u89e3\u6790\u6a21\u677f")
    public CommonResult<String> dataList(HttpServletRequest request, @PathVariable(value="alias") String alias, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("__ctx", "");
        params.put("__tic", "bpmDataTemplate");
        params.put("alias", alias);
        String html = ((FormDataTemplateManager)this.baseService).getDisplay(alias, params, queryFilter.getParams());
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)html);
    }

    @RequestMapping(value={"getBpmDataTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6")
    public ObjectNode getBpmDataTemplate(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="formKey", value="\u8868\u5355key", required=false) @RequestParam String boId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getByFormKey(formKey, boId);
    }

    @GetMapping(value={"getBODefByFormId"}, produces={"application/json; charset=utf-8"})
    public List<FormMeta> getBODefByFormId(@ApiParam(name="formId", value="\u8868\u5355Id", required=true) @RequestParam String formId) throws Exception {
        return this.formMetaManager.getBODefByFormId(formId);
    }

    @RequestMapping(value={"getByTemplateId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u660e\u7ec6")
    public ObjectNode getByTemplateId(@ApiParam(name="id", value="\u4e1a\u52a1\u6570\u636eid", required=true) @RequestParam String id, @ApiParam(name="boId", value="boId", required=false) @RequestParam String boId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getByTemplateId(id, boId);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4fe1\u606f")
    public CommonResult<FormDataTemplate> save(@RequestBody String json) throws Exception {
        FormDataTemplate temp;
        boolean flag;
        String str;
        ObjectNode obj;
        String resultMsg = null;
        FormDataTemplate bpmDataTemplate = this.getFormObject(json);
        boolean resetTemp = false;
        if (!StringUtil.isEmpty((String)json) && BeanUtils.isNotEmpty((Object)(obj = (ObjectNode)JsonUtil.toJsonNode((String)json)).get("resetTemp")) && (str = obj.get("resetTemp").asText()).equals("1")) {
            resetTemp = true;
        }
        boolean bl = flag = StringUtil.isEmpty((String)bpmDataTemplate.getId());
        if (flag && BeanUtils.isNotEmpty((Object)((Object)(temp = ((FormDataTemplateManager)this.baseService).getByAlias(bpmDataTemplate.getAlias()))))) {
            return new CommonResult(false, "\u62a5\u8868\u522b\u540d\uff1a" + bpmDataTemplate.getAlias() + "\u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u522b\u540d\uff01");
        }
        ((FormDataTemplateManager)this.baseService).save(bpmDataTemplate, resetTemp);
        resultMsg = flag ? "\u6dfb\u52a0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f" : "\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f";
        return new CommonResult(true, resultMsg, (Object)bpmDataTemplate);
    }

    @RequestMapping(value={"boBatchUpdate/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u6279\u91cf\u66f4\u65b0\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> boBatchUpdate(@ApiParam(name="params", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody List<ObjectNode> params, @PathVariable(value="boAlias") String boAlias) throws Exception {
        String resultMsg = "\u6279\u91cf\u66f4\u65b0\u6570\u636e\u6210\u529f";
        try {
            ((FormDataTemplateManager)this.baseService).boBatchUpdate(params, boAlias);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6279\u91cf\u66f4\u65b0\u6570\u636e\u5931\u8d25");
        }
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8bb0\u5f55")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u6d41\u7a0b\u5b9a\u4e49id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = ids.split(",");
        ((FormDataTemplateManager)this.baseService).removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"getForm/{formKey}/{boAlias}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355Key, boAlias \u83b7\u53d6\u8868\u5355html\uff0c \u6743\u9650\uff0c bo\u6570\u636e\u7ed3\u6784", httpMethod="GET", notes="\u83b7\u53d6bo\u6570\u636e\u7ed3\u6784")
    public Map<String, Object> getForm(@PathVariable(value="formKey") String formKey, @PathVariable(value="boAlias") String boAlias, @ApiParam(name="id", value="id", required=true) @RequestParam String id, @ApiParam(name="action", value="\u64cd\u4f5c\u7c7b\u578b") @RequestParam String action, @ApiParam(name="recordId", value="\u8868\u5355\u4fee\u6539\u8bb0\u5f55id", required=false) @RequestParam(required=false) String recordId, @ApiParam(name="dataKey", value="\u6570\u636e\u62a5\u8868KEY", required=false) @RequestParam(required=false) String dataKey) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getFormData(formKey, boAlias, id, action, recordId, dataKey);
    }

    @RequestMapping(value={"getTempDraftData/{draftId}"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u62a5\u8868\u8349\u7a3f", httpMethod="GET", notes="\u83b7\u53d6bo\u6570\u636e\u7ed3\u6784")
    public Map<String, Object> getTempDraftData(@PathVariable(value="draftId") String draftId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getTempDraftData(draftId);
    }

    @RequestMapping(value={"boSave/{boAlias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\u4fe1\u606f")
    public CommonResult<String> boSave(@ApiParam(name="params", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestBody ObjectNode params, @PathVariable(value="boAlias") String boAlias, @RequestParam(value="delDraftId") String delDraftId) throws Exception {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        ((FormDataTemplateManager)this.baseService).boSave(params, boAlias, delDraftId);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"boSaveDraft"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u4e1a\u52a1\u6a21\u677f\u8349\u7a3f", httpMethod="POST", notes="\u4fdd\u5b58\u4e1a\u52a1\u6a21\u677f\u8349\u7a3f")
    public CommonResult<String> boSaveDraft(@ApiParam(name="dataTemplateDraft", value="\u6570\u636e\u62a5\u8868\u8349\u7a3f", required=true) @RequestBody FormDataTemplateDraft dataTemplateDraft) throws Exception {
        String resultMsg = "\u4fdd\u5b58\u8349\u7a3f\u6210\u529f";
        ((FormDataTemplateManager)this.baseService).boSaveDraft(dataTemplateDraft);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"boDel/{boAlias}"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u8bb0\u5f55")
    public CommonResult<String> boDel(@PathVariable(value="boAlias") String boAlias, @ApiParam(name="ids", value="\u4e1a\u52a1\u6570\u636e", required=true) @RequestParam String ids) throws IOException {
        String resultMsg = "\u5220\u9664\u6210\u529f";
        String[] idArray = ids.split(",");
        ((FormDataTemplateManager)this.baseService).boDel(idArray, boAlias);
        return new CommonResult(true, resultMsg);
    }

    @RequestMapping(value={"editTemplate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f", httpMethod="GET", notes="\u83b7\u53d6\u6a21\u677f")
    public FormDataTemplate templateHtmlEdit(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        return (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"saveTemplate"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f\u3002", httpMethod="POST", notes="\u4fdd\u5b58\u6a21\u677f\u4fe1\u606f")
    public CommonResult<String> saveTemplate(@ApiParam(name="id", value="\u6a21\u677fid", required=true) @RequestParam String id, @ApiParam(name="templateHtml", value="\u6a21\u677fhtml", required=true) @RequestBody String templateHtml) throws IOException {
        String resultMsg = "\u4fdd\u5b58\u6210\u529f";
        FormDataTemplate template = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
        template.setTemplateHtml(templateHtml);
        ((FormDataTemplateManager)this.baseService).update((Model)template);
        return new CommonResult(true, resultMsg);
    }

    protected FormDataTemplate getFormObject(String json) throws Exception {
        if (StringUtil.isEmpty((String)json)) {
            return null;
        }
        ObjectNode obj = (ObjectNode)JsonUtil.toJsonNode((String)json);
        String displayField = obj.get("displayField").asText();
        String conditionField = obj.get("conditionField").asText();
        String sortField = obj.get("sortField").asText();
        String filterField = obj.get("filterField").asText();
        String manageField = obj.get("manageField").asText();
        String exportField = obj.get("exportField").asText();
        String treeField = obj.get("treeField").asText();
        String summaryField = obj.get("summaryField").asText();
        String remindSettingList = obj.get("remindSettingList").asText();
        obj.remove("displayField");
        obj.remove("conditionField");
        obj.remove("sortField");
        obj.remove("filterField");
        obj.remove("manageField");
        obj.remove("treeField");
        obj.remove("summaryField");
        obj.remove("remindSettingList");
        FormDataTemplate bpmDataTemplate = (FormDataTemplate)((Object)JsonUtil.toBean((JsonNode)obj, FormDataTemplate.class));
        bpmDataTemplate.setDisplayField(displayField);
        bpmDataTemplate.setConditionField(conditionField);
        bpmDataTemplate.setSortField(sortField);
        bpmDataTemplate.setFilterField(filterField);
        bpmDataTemplate.setManageField(manageField);
        bpmDataTemplate.setExportField(exportField);
        bpmDataTemplate.setTreeField(treeField);
        bpmDataTemplate.setSummaryField(summaryField);
        bpmDataTemplate.setRemindSettingList(remindSettingList);
        return bpmDataTemplate;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6570\u636e", httpMethod="GET", notes="\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u6570\u636e")
    public FormDataTemplate getJsonData(@ApiParam(name="id", value="\u6a21\u677fid", required=false) @RequestParam Optional<String> id, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey) throws Exception {
        FormDataTemplate bpmDataTemplate = null;
        String templateId = id.orElse("");
        if (StringUtil.isNotEmpty((String)id.orElse(""))) {
            bpmDataTemplate = (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)templateId));
        } else if (StringUtil.isNotEmpty((String)formKey)) {
            bpmDataTemplate = ((FormDataTemplateManager)this.baseService).getExportDisplay(formKey);
        }
        return bpmDataTemplate;
    }

    @RequestMapping(value={"export"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="getType", value="getType", required=false) @RequestParam String getType, @ApiParam(name="filterKey", value="filterKey", required=false) @RequestParam String filterKey, @ApiParam(name="expField", value="expField", required=true) @RequestParam String expField, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportData(response, formKey, getType, filterKey, expField, queryFilter);
    }

    @RequestMapping(value={"downloadMainTempFile/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response, @ApiParam(name="alias", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadMainTempFile(response, alias);
    }

    @RequestMapping(value={"getVarList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u53d8\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u76f8\u5173\u53d8\u91cf")
    public List<IContextVar> getVarList() throws Exception {
        List comVarList = (List)AppUtil.getBean((String)"queryViewComVarList");
        return comVarList;
    }

    @RequestMapping(value={"getSubData"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e", httpMethod="GET", notes="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e")
    public List<Map<String, Object>> getSubData(@ApiParam(name="alias", value="\u5b9e\u4f53\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="refId", value="\u5916\u952eid", required=true) @RequestParam String refId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getSubData(alias, refId);
    }

    @PostMapping(value={"getSubDataPagination"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e(\u5206\u9875)", httpMethod="GET", notes="\u6839\u636e\u5b9e\u4f53\u522b\u540d\u548c\u5916\u952eid\u83b7\u53d6\u5b50\u8868\u6570\u636e\uff08\u5206\u9875\uff09")
    public PageList<Map<String, Object>> getSubDataPagination(@ApiParam(name="queryFilter") @RequestBody QueryFilter queryFilter, @ApiParam(name="alias", value="\u5b9e\u4f53\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="refId", value="\u5916\u952eid", required=true) @RequestParam String refId) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getSubDataPagination(queryFilter, alias, refId);
    }

    @PostMapping(value={"importSub"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5b50\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u5b50\u8868\u6570\u636e")
    public CommonResult<String> importSub(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="refId", value="refId") @RequestParam String refId, @ApiParam(name="alias", value="\u5225\u540d") @RequestParam String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).importData(file, refId, alias);
        return new CommonResult("\u5bfc\u5165\u5b50\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"importMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> importMain(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="alias", value="\u6570\u636e\u6a21\u677f\u5225\u540d") @RequestParam String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).importMain(file, alias);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"exportSub"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u5b50\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u51fa\u5b50\u8868\u6570\u636e")
    public void exportSub(HttpServletResponse response, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody ExportSubVo exportSubVo) throws Exception {
        ((FormDataTemplateManager)this.baseService).exportSub(response, exportSubVo);
    }

    @RequestMapping(value={"getBpmDataTemplateInfo"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u76f8\u5173\u4fe1\u606f", httpMethod="GET", notes="\u6839\u636e\u8868\u5355key\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u76f8\u5173\u4fe1\u606f")
    public CommonResult<BpmDataTemplateInfoVo> getBpmDataTemplateInfo(@ApiParam(name="alias", value="\u6570\u636e\u62a5\u8868\u522b\u540d", required=true) @RequestParam String alias, @ApiParam(name="needDisplayFileds", value="\u662f\u5426\u9700\u8981\u663e\u793a\u5b57\u6bb5") @RequestParam Optional<Boolean> needDisplayFileds) throws Exception {
        FormDataTemplate bpmDataTemplate = null;
        bpmDataTemplate = needDisplayFileds.orElse(false) != false ? ((FormDataTemplateManager)this.baseService).getExportDisplay(alias) : this.bpmDataTemplateDao.getByAlias(alias);
        if (BeanUtils.isEmpty((Object)((Object)bpmDataTemplate))) {
            return new CommonResult(false, "\u6839\u636e\u62a5\u8868\u522b\u540d\u3010" + alias + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u62a5\u8868\u6570\u636e\uff01");
        }
        Form bpmForm = this.formManager.getMainByFormKey(bpmDataTemplate.getFormKey());
        if (BeanUtils.isEmpty((Object)((Object)bpmForm))) {
            return new CommonResult(false, "\u6839\u636e\u8868\u5355key\u3010" + bpmDataTemplate.getFormKey() + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8868\u5355\uff01");
        }
        BpmDataTemplateInfoVo vo = (BpmDataTemplateInfoVo)((Object)JsonUtil.toBean((String)JsonUtil.toJson((Object)((Object)bpmDataTemplate)), BpmDataTemplateInfoVo.class));
        vo.setFormId(bpmForm.getId());
        BoDef boDef = this.boDefService.getByAlias(bpmDataTemplate.getBoDefAlias());
        BoEnt boEnt = boDef.getBoEnt();
        vo.setPkField(boEnt.getPkKey().toLowerCase());
        vo.setIsExternal(boEnt.getIsExternal());
        return new CommonResult(true, "\u83b7\u53d6\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"getMyDraftList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u62a5\u8868\u8349\u7a3f\u6570\u636e(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u6211\u7684\u62a5\u8868\u8349\u7a3f\u6570\u636e(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<FormDataTemplateDraft> getMyDraftListy(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        queryFilter.addFilter("CREATE_BY_", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND);
        FieldSort sort = new FieldSort("create_time_", Direction.DESC);
        queryFilter.getSorter().add(sort);
        PageList query = this.dataTemplateDraftManager.query(queryFilter);
        return query;
    }

    @RequestMapping(value={"removeTempDraft"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8349\u7a3f\u8bb0\u5f55", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u8349\u7a3f\u8bb0\u5f55")
    public CommonResult<String> removeTempDraft(@ApiParam(name="ids", value="\u8349\u7a3fid", required=true) @RequestParam String ids) throws Exception {
        String[] aryIds = ids.split(",");
        this.dataTemplateDraftManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f\uff01", (Object)"");
    }

    @RequestMapping(value={"exportXml"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e\u62a5\u8868xml", httpMethod="GET", notes="\u5bfc\u51fa\u6d41\u7a0b\u5b9a\u4e49xml")
    public void exportXml(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="ids", value="\u6570\u636e\u62a5\u8868id", required=true) @RequestParam String ids) throws Exception {
        response.setContentType("APPLICATION/OCTET-STREAM");
        if (BeanUtils.isNotEmpty((Object)ids)) {
            String[] stringsIds = ids.split(",");
            List<String> list = Arrays.asList(stringsIds);
            String zipName = "ht_formDataTemplate_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmmss");
            Map<String, String> strXml = ((FormDataTemplateManager)this.baseService).exportDef(list);
            HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, strXml, (String)zipName);
        }
    }

    @RequestMapping(value={"importSave"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6570\u636e\u62a5\u8868\u5bfc\u5165\uff0c\u6839\u636e\u4f20\u5165\u7684\u6587\u4ef6id\u4ece\u7f13\u5b58\u4e2d\u53d6\u51faxml\u6587\u4ef6\u5bfc\u5165\uff0c\u5e76\u6e05\u9664\u7f13\u5b58", httpMethod="POST", notes="\u9644\u4ef6\u4e0a\u4f20\u64cd\u4f5c")
    public Object importSave(@ApiParam(name="confirmImport", value="\u786e\u8ba4\u5bfc\u5165", required=false) @RequestParam Optional<Boolean> confirmImport, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId, @ApiParam(name="cacheFileId", value="\u7f13\u5b58\u7684\u6570\u636e\u62a5\u8868\u6587\u4ef6id", required=false) @RequestParam Optional<String> cacheFileId) throws Exception {
        CommonResult<String> message = null;
        try {
            if (confirmImport.orElse(false).booleanValue()) {
                String byKey = ((FormDataTemplateManager)this.baseService).getImportFileFromCache(cacheFileId.get());
                if (StringUtil.isEmpty((String)byKey)) {
                    return new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:\u4e0a\u4f20\u7684\u6587\u4ef6\u5df2\u4ece\u7f13\u5b58\u4e2d\u6e05\u9664\uff0c\u8bf7\u91cd\u65b0\u5bfc\u5165\u3002");
                }
                ObjectNode objectNode = (ObjectNode)JsonUtil.toJsonNode((String)byKey);
                message = ((FormDataTemplateManager)this.baseService).importDef(objectNode, typeId.orElse(""));
            }
            ((FormDataTemplateManager)this.baseService).delImportFileFromCache(cacheFileId.orElse(""));
        }
        catch (Exception e) {
            message = new CommonResult<String>(false, "\u5bfc\u5165\u5931\u8d25:" + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"importCheck"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c,\u901a\u8fc7\u6821\u9a8c\u5219\u76f4\u63a5\u5bfc\u5165\uff0c\u5982\u6709\u91cd\u590d\u6d41\u7a0b\uff0c\u5219\u8fd4\u56de\u6d41\u7a0bxml\u7684\u7f13\u5b58key\uff0c\u5f85\u7528\u6237\u786e\u8ba4\u8986\u76d6\u540e\u518d\u6b21\u5bfc\u5165", httpMethod="POST", notes="\u6d41\u7a0b\u5bfc\u5165\u524d\u6821\u9a8c")
    public Object importCheck(MultipartHttpServletRequest request, HttpServletResponse response, @ApiParam(name="typeId", value="\u8868\u5355\u6807\u8bc6", required=false) @RequestParam Optional<String> typeId) throws Exception {
        Map fileMaps = request.getFileMap();
        Iterator it = fileMaps.values().iterator();
        ArrayList files = new ArrayList();
        while (it.hasNext()) {
            files.add(it.next());
        }
        MultipartFile fileLoad = (MultipartFile)files.get(0);
        String unZipFilePath = "";
        CommonResult message = null;
        try {
            String fileDir = StringUtil.substringBeforeLast((String)fileLoad.getOriginalFilename().toString(), (String)".");
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            ZipUtil.unZipFile((MultipartFile)fileLoad, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            String formDataTemplatesXml = FileUtil.readFile((String)(unZipFilePath + "/formDataTemplates.form.xml"));
            if (StringUtils.isEmpty((String)formDataTemplatesXml)) {
                throw new Exception("\u5bfc\u5165\u7684\u672a\u6309\u6307\u5b9a\u7684\u683c\u5f0f");
            }
            FormDataTemplateController.checkXmlFormat(formDataTemplatesXml);
            FormDataTemplateXmlList formDataTemplateXmlList = (FormDataTemplateXmlList)JAXBUtil.unmarshall((String)formDataTemplatesXml, FormDataTemplateXmlList.class);
            List<FormDataTemplateXml> list = formDataTemplateXmlList.getFormDataTemplateXmlList();
            ArrayList<String> names = new ArrayList<String>();
            for (FormDataTemplateXml formDataTemplateXml : list) {
                FormDataTemplate oformDataTemplate;
                FormDataTemplate formDataTemplate = formDataTemplateXml.getFormDataTemplate();
                if (!BeanUtils.isNotEmpty((Object)((Object)formDataTemplate)) || (oformDataTemplate = ((FormDataTemplateManager)this.baseService).getByAlias(formDataTemplate.getAlias())) == null) continue;
                names.add(formDataTemplate.getName() + "\uff08" + formDataTemplate.getAlias() + "\uff09");
            }
            ObjectNode obj = JsonUtil.getMapper().createObjectNode();
            obj.put("formDataTemplatesXml", formDataTemplatesXml);
            if (BeanUtils.isEmpty(names)) {
                message = ((FormDataTemplateManager)this.baseService).importDef(obj, typeId.orElse(""));
            } else {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((FormDataTemplateManager)this.baseService).putImportFileInCache(cacheFileId, JsonUtil.toJson((Object)obj));
                message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u62a5\u8868\u3010" + String.join((CharSequence)"\uff0c", names) + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u662f\u5426\u8986\u76d6\uff1f", (Object)cacheFileId);
            }
        }
        catch (Exception e) {
            message = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
        finally {
            File boDir = new File(unZipFilePath);
            if (boDir.exists()) {
                FileUtil.deleteDir((File)boDir);
            }
        }
        return message;
    }

    public static void checkXmlFormat(String xml) throws Exception {
        String firstName = "formDataTemplateXmlList";
        String nextName = "formDataTemplateXml";
        Document doc = Dom4jUtil.loadXml((String)xml);
        Element root = doc.getRootElement();
        String msg = "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u5bf9";
        if (!root.getName().equals(firstName)) {
            throw new Exception(msg);
        }
        List itemLists = root.elements();
        for (Element elm : itemLists) {
            if (elm.getName().equals(nextName)) continue;
            throw new Exception(msg);
        }
    }

    @PostMapping(value={"tImportMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> tImportMain(@ApiParam(name="files", value="\u4e0a\u4f20\u7684\u6587\u4ef6\u6d41") @RequestBody List<MultipartFile> file, @ApiParam(name="alias", value="\u6570\u636e\u6a21\u677f\u5225\u540d") @RequestParam String alias, @ApiParam(name="bindFilld", value="\u586b\u5145\u7684\u5b57\u6bb5\u540d") @RequestParam Optional<String> bindFilld, @ApiParam(name="fillValue", value="\u586b\u5145\u7684\u5b57\u6bb5\u503c") @RequestParam Optional<String> fillValue, @ApiParam(name="refIdValue", value="\u5916\u952e\u7684\u503c") @RequestParam Optional<String> refIdValue) throws Exception {
        BoDataImportHandler boDataImportHandler;
        FormDataTemplate template = ((FormDataTemplateManager)this.baseService).getByAlias(alias);
        BoDef boDef = this.boDefService.getByDefId(template.getBoDefId());
        BoEnt boEnt = boDef.getBoEnt();
        ArrayNode btns = (ArrayNode)JsonUtil.toJsonNode((String)template.getManageField());
        String jarId = "";
        String jarDesc = "";
        ArrayNode displays = (ArrayNode)JsonUtil.toJsonNode((String)template.getFormField());
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (JsonNode field : displays) {
            fieldMap.put(field.get("name").asText(), field.get("desc").asText());
        }
        int limt = 1000;
        for (JsonNode btn : btns) {
            if (!"import".equals(btn.get("name").asText())) continue;
            if (btn.hasNonNull("limit")) {
                limt = btn.get("limit").asInt();
            }
            if (!BeanUtils.isNotEmpty((Object)btn.get("jarId"))) continue;
            jarId = btn.get("jarId").asText();
            jarDesc = btn.get("jarDesc").asText();
        }
        if (StringUtil.isNotEmpty((String)jarId)) {
            FormImportCheckJarManager iJarManager = (FormImportCheckJarManager)AppUtil.getBean(FormImportCheckJarManager.class);
            FormImportCheckJar formImportCheckJar = (FormImportCheckJar)iJarManager.get((Serializable)((Object)jarId));
            if (BeanUtils.isEmpty((Object)((Object)formImportCheckJar))) {
                throw new RuntimeException("\u914d\u7f6e\u7684\u6821\u9a8cJar\u5305\u3010" + jarDesc + "\u3011\u4e0d\u5b58\u5728");
            }
            try {
                SystemConfigFeignService systemConfigFeignService = (SystemConfigFeignService)AppUtil.getBean(SystemConfigFeignService.class);
                ArrayNode jarFileNode = (ArrayNode)JsonUtil.toJsonNode((String)formImportCheckJar.getFilePath());
                byte[] fileBytes = systemConfigFeignService.getFileBytesById(jarFileNode.get(0).get("id").asText());
                String filePath = systemConfigFeignService.getByAlias("file.upload", "");
                String jarName = jarId + ".jar";
                FormUtil.getFile(fileBytes, filePath, jarName);
                boDataImportHandler = FormUtil.loadImportHandler((String)filePath + "/" + jarName, formImportCheckJar.getClassPath());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException("\u89e3\u6790\u6821\u9a8cJar\u5305\u5931\u8d25\uff1a" + e2.getMessage());
            }
        } else {
            boDataImportHandler = null;
        }
        Iterator<MultipartFile> it = file.iterator();
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        while (it.hasNext()) {
            MultipartFile f = it.next();
            List columnList = boEnt.getColumnList();
            HashMap<String, BoAttribute> columnMap = new HashMap<String, BoAttribute>();
            for (BoAttribute boAttribute : columnList) {
                String desc = boAttribute.getDesc();
                if (fieldMap.containsKey(boAttribute.getName())) {
                    desc = (String)fieldMap.get(boAttribute.getName());
                    nameFieldMap.put(boAttribute.getDesc(), desc);
                }
                columnMap.put(desc, boAttribute);
            }
            List<Map<String, Object>> rows = ((FormDataTemplateManager)this.baseService).resolutionExcel(f, columnMap, bindFilld.orElse(""));
            if (rows.size() > limt) {
                throw new RuntimeException("\u8d85\u8fc7\u5355\u6b21\u5bfc\u5165\u6700\u5927\u9650\u5236\uff1a" + limt + "\u6761");
            }
            ExecutorService executorService = Executors.newCachedThreadPool();
            IUser currentUser = ContextUtil.getCurrentUser();
            executorService.execute(() -> {
                try {
                    ContextUtil.setCurrentUser((IUser)currentUser);
                    this.baseContext.setTempTenantId(currentUser.getTenantId());
                    long currentTimeMillis = System.currentTimeMillis();
                    ((FormDataTemplateManager)this.baseService).checkAndImportData(rows, boEnt, columnMap, bindFilld.orElse(""), fillValue.orElse(""), refIdValue.orElse(""), template, boDataImportHandler, nameFieldMap);
                    System.err.println("\u5bfc\u5165\uff1a" + rows.size() + "\u6761\u6570\u636e\uff0c\u7528\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis) / 1000L + "\u79d2");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("tabName", boEnt.getTableName());
        obj.put("oldValue", refIdValue.get());
        return new CommonResult(true, "\u4e0a\u4f20\u6210\u529f\uff0c\u8bf7\u7a0d\u540e\u67e5\u8be2\u7ed3\u679c", (Object)JsonUtil.toJson((Object)obj));
    }

    @RequestMapping(value={"downloadMainTempByFormKey/{alias}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempByFormKey(HttpServletResponse response, @ApiParam(name="alias", value="\u8868\u5355\u522b\u540d", required=true) @PathVariable String alias) throws Exception {
        ((FormDataTemplateManager)this.baseService).downloadMainTempByFormKey(response, alias);
    }

    @RequestMapping(value={"getExistsByFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5df2\u5b58\u5728\u7684\u8868\u5355\u5217\u8868", httpMethod="GET", notes="\u83b7\u53d6\u5df2\u5b58\u5728\u7684\u8868\u5355\u5217\u8868")
    public List<FormDataTemplate> getExistsByFormKey(@ApiParam(name="formKey", value="\u8868\u5355Key", required=true) @RequestParam String formKey) throws Exception {
        return ((FormDataTemplateManager)this.baseService).getExistsByFormKey(formKey);
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7id\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f", httpMethod="GET", notes="\u901a\u8fc7id\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f")
    public FormDataTemplate getFormDataTemplateById(@ApiParam(name="id", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677fid", required=true) @RequestParam String id) throws Exception {
        return (FormDataTemplate)((FormDataTemplateManager)this.baseService).get((Serializable)((Object)id));
    }

    @RequestMapping(value={"getByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f", httpMethod="GET", notes="\u901a\u8fc7\u522b\u540d\u83b7\u53d6\u4e1a\u52a1\u6570\u636e\u6a21\u677f")
    public FormDataTemplate getFormDataTemplateByAlias(@ApiParam(name="alias", value="\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"alias_", (Object)alias);
        return (FormDataTemplate)((Object)((FormDataTemplateManager)this.baseService).getOne((Wrapper)queryWrapper, false));
    }
}

