package com.artfess.base.interceptor;

import java.util.List;

/**
 * SQL返回值处理过滤链
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年7月27日
 */
public interface ResultSetFilter {
	/**
	 * 对数据进行处理
	 * @param obj
	 * @return
	 */
	void handle(Object obj);
	
	/**
	 * 是否支持处理该SQL
	 * @param id			MappedStatement id
	 * @param sql			sql语句
	 * @param tableNames	sql语句中包含的表名
	 * @return				当前过滤器是否支持处理这条SQL的返回值
	 */
	boolean support(String id, String sql, List<String> tableNames);
	
	/**
	 * 过滤链排序，过滤链的执行顺序按照从小到大
	 * <p>默认为1</p>
	 * @return
	 */
	default int getOrder() {
		return 1;
	};
}
