package com.artfess.base.entity;

import com.artfess.base.util.CommonUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import org.jsoup.helper.StringUtil;
import org.springframework.util.Assert;

/**
 * 基础树实体类
 *
 * @company 阿特菲斯
 * @author chens
 * @email chens@artfess.com
 * @date 2021年3月5日
 */
public abstract class CqltTreeModel<T extends CqltTreeModel<?>> extends BaseModel<T>{
	private static final long serialVersionUID = 1L;

	@TableId(value = "id_", type = IdType.ASSIGN_ID)
	@ApiModelProperty(value="主键")
	protected String id;

	@ApiModelProperty(value = "编码")
	@TableField(value = "CODE_",condition=SqlCondition.LIKE)
	protected String code;

	@ApiModelProperty(value = "名称")
	@TableField(value = "NAME_",condition=SqlCondition.LIKE)
	protected String name;

	@ApiModelProperty(value = "上级_ID")
	@TableField("PARENT_ID_")
	protected String parentId;

	@ApiModelProperty(value = "子节点个数", hidden = true)
	@TableField("HAS_CHILDREN_")
	protected Integer hasChildren;

	@ApiModelProperty(value = "ID_全路径", hidden = true)
	@TableField(value = "FULL_ID_",condition = SqlCondition.LIKE_RIGHT)
	protected String fullId;

	@ApiModelProperty(value = "名称_全路径", hidden = true)
	@TableField(value = "FULL_NAME_",condition = SqlCondition.LIKE_RIGHT )
	protected String fullName;

	@ApiModelProperty(value = "编码_全路径", hidden = true)
	@TableField(value = "FULL_CODE_",condition = SqlCondition.LIKE_RIGHT )
	protected String fullCode;

	@ApiModelProperty(value = "排序号")
	@TableField("SN_")
	protected Integer sn;

	@ApiModelProperty(value = "被移动的id")
	@TableField(exist=false)
	private String sourceId;


	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getParentId() {
		return parentId;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public Integer getHasChildren() {
		return hasChildren;
	}

	public void setHasChildren(Integer hasChildren) {
		this.hasChildren = hasChildren;
	}

	public String getFullId() {
		return fullId;
	}

	public void setFullId(String fullId) {
		this.fullId = fullId;
	}

	public String getFullName() {
		return fullName;
	}

	public void setFullName(String fullName) {
		this.fullName = fullName;
	}

	public Integer getSn() {
		return sn;
	}

	public void setSn(Integer sn) {
		this.sn = sn;
	}

	public String getFullCode() {
		return fullCode;
	}

	public void setFullCode(String fullCode) {
		this.fullCode = fullCode;
	}

	public void checkConstraints() {
		Assert.hasText(this.code, "编码不能为空。");
		Assert.hasText(this.name, "名称不能为空。");
	}

	public void checkConstraints(CqltTreeModel other) {
		checkConstraints();
		if (other != null) {
			Assert.isTrue(!getCode().equalsIgnoreCase(other.getCode()),"编码不能重复。");
//			Assert.isTrue(!getName().equalsIgnoreCase(other.getName()),"名称不能重复。");
		}
	}

	public void buildFullIdAndName(CqltTreeModel parent) {
		String fullId = CommonUtil.createFileFullName(((parent == null) || (parent.getFullId() == null)) ? "": parent.getFullId(), getId().toString(), "");
		String fullName = CommonUtil.createFileFullName(((parent == null) || (parent.getFullName() == null)) ? "": parent.getFullName(), getName(), "");
		String fullCode = CommonUtil.createFileFullName(((parent == null) || (parent.getFullCode() == null)) ? "": parent.getFullCode(), getCode(), "");
		setFullId(fullId);
		setFullName(fullName);
		setFullCode(fullCode);
	}

	@JsonIgnore(value = true)
	public boolean isNew() {
		return StringUtil.isBlank(this.id);
	}

	public boolean isUpdateName(String oldName) {
		return ((!(isNew())) && (!(this.name.equalsIgnoreCase(oldName))));
	}


	public String getSourceId() {
		return sourceId;
	}

	public void setSourceId(String sourceId) {
		this.sourceId = sourceId;
	}
}
