package com.artfess.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModelProperty.AccessMode;

import javax.xml.bind.annotation.XmlTransient;
import java.time.LocalDateTime;

/**
 * 带自动填充字段的基础实体类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2020年4月8日
 */
public abstract class AutoFillFullModel<T extends AutoFillFullModel<?>> extends BaseModel<T>{
	private static final long serialVersionUID = 1L;
	
	@ApiModelProperty(value = "创建人ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_by_", fill=FieldFill.INSERT, select=false)
	private String createBy;

	@ApiModelProperty(value = "创建人姓名", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_name_", fill=FieldFill.INSERT, select=true)
	private String createName;


	@ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_org_id_", fill=FieldFill.INSERT, select=true)
	private String createOrgId;


	@ApiModelProperty(value = "创建人组织名称", hidden=false, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_org_name_", fill=FieldFill.INSERT, select=true)
	private String createOrgName;


	@ApiModelProperty(value = "创建人部门ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_dept_id_", fill=FieldFill.INSERT, select=false)
	private String createDeptId;


	@ApiModelProperty(value = "创建人部门名称", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_dept_name_", fill=FieldFill.INSERT, select=true)
	private String createDeptName;

	@ApiModelProperty(value = "创建时间", hidden=false, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
	private LocalDateTime createTime;

	@ApiModelProperty(value = "更新人ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_by_", fill=FieldFill.UPDATE, select=false)
	private String updateBy;

	@ApiModelProperty(value = "更新人姓名", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_name_", fill=FieldFill.UPDATE, select=false)
	private String updateName;

	@JsonIgnore
	@ApiModelProperty(value = "更新人组织ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_org_id_", fill=FieldFill.UPDATE, select=false)
	private String updateOrgId;

	@JsonIgnore
	@ApiModelProperty(value = "更新人组织名称", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_org_name_", fill=FieldFill.UPDATE, select=false)
	private String updateOrgName;

	@JsonIgnore
	@ApiModelProperty(value = "更新人部门ID", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_dept_id_", fill=FieldFill.UPDATE, select=false)
	private String updateDeptId;

	@JsonIgnore
	@ApiModelProperty(value = "更新人部门名称", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_dept_name_", fill=FieldFill.UPDATE, select=false)
	private String updateDeptName;


	@ApiModelProperty(value = "更新时间", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="update_time_", fill=FieldFill.UPDATE, select=false)
	private LocalDateTime updateTime;

	@JsonIgnore
	@ApiModelProperty(value = "最后更新时间", hidden=true, accessMode=AccessMode.READ_ONLY)
	@TableField(updateStrategy=FieldStrategy.NOT_NULL,value="last_time_", fill=FieldFill.INSERT_UPDATE, select=false)
	private Long lastTime;

	public String getCreateBy() {
		return createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getCreateOrgId() {
		return createOrgId;
	}

	public void setCreateOrgId(String createOrgId) {
		this.createOrgId = createOrgId;
	}

	public String getCreateName() {
		return createName;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}

	public String getCreateOrgName() {
		return createOrgName;
	}

	public void setCreateOrgName(String createOrgName) {
		this.createOrgName = createOrgName;
	}


	public String getCreateDeptId() {
		return createDeptId;
	}

	public void setCreateDeptId(String createDeptId) {
		this.createDeptId = createDeptId;
	}

	public String getCreateDeptName() {
		return createDeptName;
	}

	public void setCreateDeptName(String createDeptName) {
		this.createDeptName = createDeptName;
	}
	
	@XmlTransient
	public LocalDateTime getCreateTime() {
		return createTime;
	}

	public void setCreateTime(LocalDateTime createTime) {
		this.createTime = createTime;
	}

	public String getUpdateBy() {
		return updateBy;
	}

	public void setUpdateBy(String updateBy) {
		this.updateBy = updateBy;
	}

	public String getUpdateName() {
		return updateName;
	}

	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	public String getUpdateOrgId() {
		return updateOrgId;
	}

	public void setUpdateOrgId(String updateOrgId) {
		this.updateOrgId = updateOrgId;
	}

	public String getUpdateOrgName() {
		return updateOrgName;
	}

	public void setUpdateOrgName(String updateOrgName) {
		this.updateOrgName = updateOrgName;
	}

	public String getUpdateDeptId() {
		return updateDeptId;
	}

	public void setUpdateDeptId(String updateDeptId) {
		this.updateDeptId = updateDeptId;
	}

	public String getUpdateDeptName() {
		return updateDeptName;
	}

	public void setUpdateDeptName(String updateDeptName) {
		this.updateDeptName = updateDeptName;
	}

	@XmlTransient
	public LocalDateTime getUpdateTime() {
		return updateTime;
	}

	public void setUpdateTime(LocalDateTime updateTime) {
		this.updateTime = updateTime;
	}


	@XmlTransient
	public Long getLastTime() {
		return lastTime;
	}

	public void setLastTime(Long lastTime) {
		this.lastTime = lastTime;
	}

	@Override
	public String toString() {
		return "BaseModel{" +
				"createBy='" + createBy + '\'' +
				", createName='" + createName + '\'' +
				", createOrgId='" + createOrgId + '\'' +
				", createOrgName='" + createOrgName + '\'' +
				", createDeptId='" + createDeptId + '\'' +
				", createDeptName='" + createDeptName + '\'' +
				", createTime=" + createTime +
				", updateBy='" + updateBy + '\'' +
				", updateName='" + updateName + '\'' +
				", updateOrgId='" + updateOrgId + '\'' +
				", updateOrgName='" + updateOrgName + '\'' +
				", updateDeptId='" + updateDeptId + '\'' +
				", updateDeptName='" + updateDeptName + '\'' +
				", updateTime=" + updateTime +
				", lastTime=" + lastTime +
				'}';
	}

}
