package com.artfess.base.dataway;

import net.hasor.core.AppContext;
import net.hasor.core.DimModule;
import net.hasor.dataql.fx.db.LookupDataSourceListener;
import net.hasor.dataway.DatawayService;
import net.hasor.db.JdbcModule;
import net.hasor.db.Level;
import net.hasor.spring.SpringModule;
import net.hasor.web.WebApiBinder;
import net.hasor.web.WebModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.sql.DataSource;

/**
 * @ClassName DatawayModule
 * @Author ly
 * @Date 2020/7/30 21:48
 * @Description: Dataway初始配置
 **/
@DimModule
@Component
public class DatawayModule implements WebModule,SpringModule {
    @Autowired
    private DataSource dataSource = null;

    @Override
    public void loadModule(WebApiBinder apiBinder) throws Throwable {
        apiBinder.installModule(new JdbcModule(Level.Full, this.dataSource));
        apiBinder.bindSpiListener(LookupDataSourceListener.class, new MyLookupDataSourceListenerImpl());
    }

    @Override
    public void onStart(AppContext appContext) throws Throwable {
        DatawayService dataWayService = appContext.getInstance(DatawayService.class);
        DatawaySpringUtil.setDatawayService(dataWayService);
    }
  /*  @Override
    public void loadModule(ApiBinder apiBinder) throws Throwable {
        apiBinder.installModule(new JdbcModule(Level.Full, this.dataSource));
        apiBinder.bindSpiListener(LookupDataSourceListener.class, new MyLookupDataSourceListenerImpl());
    }*/



}