package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 科目级别
 */
@Getter
public enum SubjectLevelEnum {
    ONE("1", "一级"),

    TWO("2", "二级"),

    THREE("3", "三级"),

    FOUR("4", "四级"),

    FIVE("5", "五级"),

    SIX("6", "六级"),

    ;

    SubjectLevelEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        SubjectLevelEnum[] values = values();
        for (SubjectLevelEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }
}
