/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.template.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.template.TemplateEngine;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.Version;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.ui.freemarker.SpringTemplateLoader;

@Service
@Transactional
public class FreeMarkerEngine
implements InitializingBean,
TemplateEngine {
    private Version version = Configuration.VERSION_2_3_28;
    private Configuration configuration;
    @Resource
    ResourceLoader resourceLoader;
    @Value(value="${spring.freemarker.template-loader-path}")
    private String templateLoaderPath = "classpath:/templates/";
    @Value(value="${spring.freemarker.charset}")
    private String defaultEncoding = "UTF-8";
    private String commonTemplateName = "common_template_freemark";

    public void afterPropertiesSet() throws Exception {
        this.configuration = new Configuration(this.version);
        SpringTemplateLoader templateLoader = new SpringTemplateLoader(this.resourceLoader, this.templateLoaderPath);
        this.configuration.setTemplateLoader((TemplateLoader)templateLoader);
        this.configuration.setDefaultEncoding(this.defaultEncoding);
    }

    @Override
    public String parseByTempName(String templateName, Object model) throws Exception {
        try {
            Template template = this.configuration.getTemplate(templateName);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)model);
        }
        catch (Exception ex) {
            throw new BaseException(String.format("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s", ExceptionUtils.getRootCauseMessage((Throwable)ex)));
        }
    }

    @Override
    public String parseByTemplate(String template, Object model) throws Exception {
        try {
            Configuration cfg = new Configuration(this.version);
            StringTemplateLoader loader = new StringTemplateLoader();
            cfg.setDefaultEncoding(this.defaultEncoding);
            cfg.setTemplateLoader((TemplateLoader)loader);
            cfg.setClassicCompatible(true);
            loader.putTemplate(this.commonTemplateName, template);
            Template templateObj = cfg.getTemplate(this.commonTemplateName);
            templateObj.getConfiguration().setNumberFormat("#");
            StringWriter writer = new StringWriter();
            templateObj.process(model, (Writer)writer);
            loader.removeTemplate(this.commonTemplateName);
            return writer.toString();
        }
        catch (Exception ex) {
            throw new BaseException(String.format("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s", ExceptionUtils.getRootCauseMessage((Throwable)ex)));
        }
    }

    @Override
    public String parseByStringTemplate(String templateSource, Object model) throws Exception {
        try {
            Configuration cfg = new Configuration(this.version);
            StringTemplateLoader loader = new StringTemplateLoader();
            cfg.setTemplateLoader((TemplateLoader)loader);
            cfg.setClassicCompatible(true);
            loader.putTemplate("freemaker", templateSource);
            Template template = cfg.getTemplate("freemaker");
            StringWriter writer = new StringWriter();
            template.process(model, (Writer)writer);
            return writer.toString();
        }
        catch (Exception ex) {
            throw new BaseException(String.format("\u6a21\u677f\u89e3\u6790\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s", ExceptionUtils.getRootCauseMessage((Throwable)ex)));
        }
    }
}

