/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.aop;

import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.aop.AopCacheHelper;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ExceptionUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ThreadMsgUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.base.util.WebUtil;
import com.artfess.base.util.time.DateUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SysLogsAspect {
    private Logger logger = LoggerFactory.getLogger(SysLogsAspect.class);
    @Resource
    JmsProducer jmsProducer;
    @Resource
    AopCacheHelper aopCacheHelper;
    private static String moduleType = "base";

    @Value(value="${spring.application.name:base}")
    public void setModuleType(String param) {
        moduleType = param;
    }

    @Around(value="execution(* *..*Controller.*(..)) && (@annotation(io.swagger.annotations.ApiOperation) || @annotation(com.artfess.base.annotation.PowerLogInfo))")
    public Object sysLogs(ProceedingJoinPoint joinPoint) throws Throwable {
        Object proceed;
        block16: {
            ApiOperation apiOperation;
            String opeName;
            Class<?> targetClass = joinPoint.getTarget().getClass();
            String methodName = joinPoint.getSignature().getName();
            Method[] methods = targetClass.getMethods();
            Method method = null;
            for (int i = 0; i < methods.length; ++i) {
                if (methods[i].getName() != methodName) continue;
                method = methods[i];
                break;
            }
            if (StringUtil.isEmpty(opeName = (apiOperation = method.getAnnotation(ApiOperation.class)).value())) {
                opeName = apiOperation.notes();
            }
            ThreadMsgUtil.addMapMsg("sysLogOpeName", opeName);
            proceed = null;
            HttpServletRequest request = HttpUtil.getRequest();
            if (BeanUtils.isNotEmpty(request)) {
                request.setAttribute("enterController", (Object)true);
            }
            proceed = joinPoint.proceed();
            if (BeanUtils.isEmpty(request)) {
                return proceed;
            }
            Object[] args = joinPoint.getArgs();
            String reqUrl = request.getRequestURI();
            try {
                StringBuffer sb = new StringBuffer();
                if (BeanUtils.isNotEmpty(args)) {
                    for (Object object : args) {
                        if (object instanceof ServletRequest || object instanceof ServletResponse) continue;
                        try {
                            String json = JsonUtil.toJson(object);
                            sb.append(json);
                        }
                        catch (Exception e) {
                            sb.append(object.toString());
                        }
                    }
                }
                String executor = "\u7cfb\u7edf[\u65e0\u7528\u6237\u767b\u5f55\u7cfb\u7edf]";
                if (StringUtil.isNotEmpty(AuthenticationUtil.getCurrentUserFullname())) {
                    executor = String.format("%s[%s]", AuthenticationUtil.getCurrentUserFullname(), AuthenticationUtil.getCurrentUsername());
                }
                ObjectNode objectNode = JsonUtil.getMapper().createObjectNode();
                objectNode.put("id", UniqueIdUtil.getSuid());
                objectNode.put("opeName", opeName);
                objectNode.put("moduleType", moduleType);
                objectNode.put("reqUrl", reqUrl);
                objectNode.put("opeContent", sb.toString());
                objectNode.put("type", "sysLog");
                objectNode.putPOJO("executionTime", (Object)DateUtil.getCurrentDate());
                String tenantId = HttpUtil.getTenantId();
                if (BeanUtils.isEmpty(tenantId)) {
                    tenantId = "-1";
                }
                objectNode.put("tenantId", tenantId);
                if ("/sso/auth".matches(reqUrl) || "/auth".matches(reqUrl)) {
                    executor = (String)request.getAttribute("loginUser");
                    objectNode.put("logType", "\u767b\u5f55\u65e5\u5fd7");
                    objectNode.put("executor", executor);
                    objectNode.put("ip", WebUtil.getIpAddr(request));
                    this.jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysLoginQueue");
                    break block16;
                }
                objectNode.put("logType", "\u64cd\u4f5c\u65e5\u5fd7");
                objectNode.put("executor", executor);
                objectNode.put("ip", WebUtil.getIpAddr(request));
                PowerLogInfo powerLogInfo = method.getAnnotation(PowerLogInfo.class);
                if (ObjectUtils.isNotEmpty((Object)powerLogInfo)) {
                    objectNode.put("logType", powerLogInfo.logType().getName());
                }
                this.jmsProducer.sendToQueue(JsonUtil.toJson(objectNode), "sysLogQueue");
            }
            catch (Exception e) {
                this.logger.error("\u4fdd\u5b58\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\u3002" + ExceptionUtil.getExceptionMessage(e));
            }
        }
        return proceed;
    }
}

