/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.util;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.base.util.Base64;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.JsonUtil;
import com.artfess.integrate.consts.WeChatOffAccConsts;
import com.artfess.integrate.consts.WeChatWorkConsts;
import com.artfess.integrate.model.msg.WxBaseMessage;
import com.artfess.integrate.model.msg.impl.WxNewsMessage;
import com.artfess.integrate.util.WechatOffAccTokenUtil;
import java.util.HashMap;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class WeiXinUtil {
    public static String sendTextMessage(WxBaseMessage msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getSendMsgUrl(), (String)JsonUtil.toJson((Object)msg), (String)"POST");
        return resultJson;
    }

    public static String sendNewsMessage(WxNewsMessage msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest((String)WeChatWorkConsts.getSendMsgUrl(), (String)msg.toString(), (String)"POST");
        return resultJson;
    }

    public static String sendWeiXinMessage(String msg) throws Exception {
        String resultJson = HttpUtil.sendHttpsRequest((String)WeChatOffAccConsts.send((String)WechatOffAccTokenUtil.getToken()), (String)msg, (String)"POST");
        return resultJson;
    }

    public static String renderMobileUrl(JmsMessage jmsMessage) throws Exception {
        String newUrl = "";
        try {
            Document doc = Jsoup.parseBodyFragment((String)jmsMessage.getContent());
            Elements elms = doc.getElementsByTag("a");
            Map vars = jmsMessage.getExtendVars();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taskId", vars.getOrDefault("taskId", ""));
            params.put("instId", vars.getOrDefault("instId", ""));
            params.put("templateType", vars.getOrDefault("templateType", ""));
            params.put("templateAlias", jmsMessage.getTemplateAlias());
            for (Element e : elms) {
                String oldUrl = e.attr("href");
                params.put("originUrl", oldUrl);
                String paramStr = Base64.getBase64((String)JsonUtil.toJson(params));
                newUrl = WeChatWorkConsts.getWxAuthorize((String)paramStr);
                jmsMessage.setContent(jmsMessage.getContent().replace(oldUrl, newUrl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newUrl;
    }

    public static String renderOffAccUrl(JmsMessage jmsMessage) {
        String newUrl = "";
        try {
            Document doc = Jsoup.parseBodyFragment((String)jmsMessage.getContent());
            Elements elms = doc.getElementsByTag("a");
            Map vars = jmsMessage.getExtendVars();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("taskId", vars.getOrDefault("taskId", ""));
            params.put("instId", vars.getOrDefault("instId", ""));
            params.put("templateType", vars.getOrDefault("templateType", ""));
            params.put("templateAlias", jmsMessage.getTemplateAlias());
            for (Element e : elms) {
                String oldUrl = e.attr("href");
                params.put("originUrl", oldUrl);
                String paramStr = Base64.getBase64((String)JsonUtil.toJson(params));
                newUrl = WeChatOffAccConsts.getWxAuthorize((String)paramStr);
                jmsMessage.setContent(jmsMessage.getContent().replace(oldUrl, newUrl));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newUrl;
    }
}

