package com.artfess.gyl.utils;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Component
public class OrgUtils {

    @Resource
    private BizEnterpriseManager enterpriseManager;
    /**
     * 根据历史组织编码和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByHisOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column, BizEnterpriseManager enterpriseManager){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if(BeanUtils.isNotEmpty(orgInfo)){
                orgCode = orgInfo.get("code").asText();
            }
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                BizEnterprise enterprise = enterpriseManager.getByOrgIdOrCode(orgId,orgCode);
                queryFilter.addFilter(column, orgCode, QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
                if(BeanUtils.isNotEmpty(enterprise)) {
                    queryFilter.addFilter(column, enterprise.getHistoryCompanyCode(), QueryOP.EQUAL, FieldRelation.OR,"orgQuery");
                }
            }
        }
        return queryFilter;
    }

    /**
     * 根据公司编码和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByOrgCodeAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            ObjectNode orgInfo = ucFeignService.getOrgByIdOrCode(orgId);
            String orgCode = "";
            if(BeanUtils.isNotEmpty(orgInfo)){
                orgCode = orgInfo.get("code").asText();
            }
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, orgCode, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }


    /**
     * 根据公司和角色过滤列表数据查询，如果是管理员或者角色是sysRole、ld、yyadmin则不过滤，否则过滤掉数据，只查询自己的数据
     * @param queryFilter 查询过滤条件
     * @param ucFeignService ucFeignService类，直接在使用类中注入
     * @param column 列名，用于过滤数据的列名
     * @return
     */
    public static QueryFilter addFilterByUserOrgAndRole(QueryFilter queryFilter, UCFeignService ucFeignService, String column){
        //查询项目时通过项目人员增加查询条件，只有管理员或者可以管理此项目的人员才能查询到此项目
        IUser user= ContextUtil.getCurrentUser();
        // 如果是管理员或者没有项目权限
        if(null != user){
            boolean disableAll = false;
            Integer userType = user.getUserType();
            String userId = user.getUserId();
            String orgId = ContextUtil.getCurrentOrgId();
            CommonResult<JsonNode> userNode = ucFeignService.getUserById(userId);
            if (userNode.getState()) {
                JsonNode userJsonNode = userNode.getValue();
                if(null != userJsonNode){
                    userType = userJsonNode.get("userType").asInt();
                }
            }
            // 1.先通过用户类型判断，过滤掉超级管理员之类的用户
            if(userType != null && userType !=0 && userType != 1){
                // 2.再通过角色判断，过滤掉没有对应角色权限的人员
                // 获取当前用户拥有的所有角色
                Set<String> set = new HashSet<String>();
                List<ObjectNode> list = ucFeignService.getRoleListByAccount(user.getAccount());
                if(BeanUtils.isNotEmpty(list)){
                    for (ObjectNode objectNode : list) {
                        set.add(objectNode.get("code").asText());
                    }
                }
                if(!set.contains("sysRole") && !set.contains("qrsk") && !set.contains("ld") && !set.contains("yyadmin")){
                    disableAll = true;
                }
            }
            if(disableAll){
                queryFilter.addFilter(column, orgId, QueryOP.EQUAL);
            }
        }
        return queryFilter;
    }
}
