package com.artfess.gyl.supplierOut.manager.impl;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.gyl.base.model.BizSupplierQualificationDatabase;
import com.artfess.gyl.supplierApply.manager.BizSupplierEnterpriseManager;
import com.artfess.gyl.supplierApply.model.BizSupplierEnterprise;
import com.artfess.gyl.supplierApply2.model.BizSupplierEnterpriseAccess;
import com.artfess.gyl.supplierApply2.vo.EnterpriseAccess2PageVo;
import com.artfess.gyl.supplierOut.manager.BizSupplierEnterpriseOutSupplyConditionManager;
import com.artfess.gyl.supplierOut.model.BizSupplierEnterpriseOut;
import com.artfess.gyl.supplierOut.dao.BizSupplierEnterpriseOutDao;
import com.artfess.gyl.supplierOut.manager.BizSupplierEnterpriseOutManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.gyl.supplierOut.model.BizSupplierEnterpriseOutSupplyCondition;
import com.artfess.gyl.supplierOut.vo.SupplierEnterpriseOutPageVo;
import com.artfess.gyl.thirdParty.manager.BizEnterpriseManager;
import com.artfess.gyl.thirdParty.model.BizEnterprise;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 淘汰供应商记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wubin
 * @since 2025-12-04
 */
@Service
public class BizSupplierEnterpriseOutManagerImpl extends BaseManagerImpl<BizSupplierEnterpriseOutDao, BizSupplierEnterpriseOut> implements BizSupplierEnterpriseOutManager {

    @Resource
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Resource
    private BizSupplierEnterpriseOutSupplyConditionManager outSupplyConditionManager;

    @Resource
    private BizEnterpriseManager enterpriseManager;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public Boolean saveModel(BizSupplierEnterpriseOut model) {
        //修改合格供应商类型（淘汰/退出）
        String supplierEnterpriseId = model.getSupplierEnterpriseId();
        String type = model.getType();
        supplierEnterpriseManager.update(new LambdaUpdateWrapper<BizSupplierEnterprise>()
                .eq(BizSupplierEnterprise::getId,supplierEnterpriseId)
                .set(BizSupplierEnterprise::getType,type));
        //保存淘汰供应商记录
        save(model);
        //保存供货情况
        List<BizSupplierEnterpriseOutSupplyCondition> supplyConditionList = model.getSupplyConditionList();
        if (supplyConditionList != null && supplyConditionList.size() >0){
            String supplierEnterpriseOutId = model.getId();
            for (BizSupplierEnterpriseOutSupplyCondition outSupplyCondition : supplyConditionList) {
                outSupplyCondition.setSupplierEnterpriseOutId(supplierEnterpriseOutId);
            }
            outSupplyConditionManager.saveBatch(supplyConditionList);
        }
        return true;
    }

    @Override
    public BizSupplierEnterpriseOut getInfo(String id) {
        BizSupplierEnterpriseOut model = get(id);
        List<BizSupplierEnterpriseOutSupplyCondition> list = outSupplyConditionManager.list(new LambdaQueryWrapper<BizSupplierEnterpriseOutSupplyCondition>()
                .eq(BizSupplierEnterpriseOutSupplyCondition::getSupplierEnterpriseOutId, model.getId())
                .eq(BizSupplierEnterpriseOutSupplyCondition::getIsDele, "0"));
        model.setSupplyConditionList(list);
        return model;
    }

    @Override
    public BizSupplierEnterpriseOut getBySupplierEnterpriseId(String supplierEnterpriseId) {
        BizSupplierEnterprise supplierEnterprise = supplierEnterpriseManager.get(supplierEnterpriseId);
        String enterpriseId = supplierEnterprise.getEnterpriseId();
        String supplierId = supplierEnterprise.getSupplierId();
        BizEnterprise enterprise = enterpriseManager.getByOrgIdOrCode(enterpriseId, null);
        BizEnterprise supplier = enterpriseManager.getByOrgIdOrCode(supplierId, null);
        BizSupplierEnterpriseOut model = new BizSupplierEnterpriseOut();
        model.setEnterpriseId(enterprise.getOrgId());
        model.setEnterpriseCode(enterprise.getCompanyCode());
        model.setEnterpriseName(enterprise.getCompanyName());
        model.setSupplierId(supplier.getOrgId());
        model.setSupplierCode(supplier.getCompanyCode());
        model.setSupplierName(supplier.getCompanyName());
        model.setSupplierCompanyEbe(supplier.getCompanyEbe());
        model.setSupplierContact(supplier.getCompanyContact());
        model.setSupplierAddr(supplier.getCompanyAddr());
        model.setSupplierTel(supplier.getContactTel());
        model.setSupplierOwnerType(supplier.getOwnerType());
        model.setSupplierCompanyEbe(supplier.getCompanyEbe());
        model.setCatId(supplierEnterprise.getCatId());
        model.setCatNo(supplierEnterprise.getCatNo());
        model.setCatName(supplierEnterprise.getCatName());
        model.setGradingId(supplierEnterprise.getGradingId());
        model.setGradingCode(supplierEnterprise.getGradingNo());
        model.setGradingName(supplierEnterprise.getGradingName());
        model.setCooperationDate(supplierEnterprise.getSelectionDate());
        model.setSupplierEnterpriseId(supplierEnterprise.getId());
        return model;
    }

    @Override
    public PageList<BizSupplierEnterpriseOut> queryPage(QueryFilter<BizSupplierEnterpriseOut> queryFilter) {
        return query(queryFilter);
    }
}
