package com.artfess.gyl.supplierEva.vo;

import com.artfess.gyl.supplierEva.model.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

@Data
public class EvaluationOptVo extends BizSupplierPerformanceEvaluation {

    @ApiModelProperty(value = "是否已经评分")
    private String isOpt;

    @ApiModelProperty(value = "通知状态")
    private String notificationStatus;

    @ApiModelProperty(value = "通知单id")
    private String notificationId;

    @ApiModelProperty(value = "整改措施id")
    private String reportId;

    @ApiModelProperty(value = "整改状态")
    private String correctionStatus;

    @ApiModelProperty(value = "评分明细")
    private List<BizSupplierPerformanceEvaluationRating> details;

    @ApiModelProperty(value = "考核记录")
    private List<BizSupplierPerformanceEvaluationApprovalRecord> records;

    @ApiModelProperty(value = "考核通知")
    private BizSupplierPerformanceEvaluationNotification notification;

    @ApiModelProperty(value = "整改报告")
    private BizSupplierPerformanceEvaluationCorrectionReport report;

    public EvaluationOptVo(){

    }

    public EvaluationOptVo(BizSupplierPerformanceEvaluation evaluation) {
        try {
            BeanUtils.copyProperties(this,evaluation);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}
