package com.artfess.gyl.supplierEva.vo;

import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationDetails;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationInterval;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationNotification;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;

@Data
public class ConfigurationVo extends BizSupplierPerformanceEvaluationConfiguration {

    @ApiModelProperty(value = "评分项详情")
    private List<BizSupplierPerformanceEvaluationDetails> details;

    @ApiModelProperty(value = "分值配置")
    private List<BizSupplierPerformanceEvaluationInterval> intervals;


    public ConfigurationVo(){

    }

    public ConfigurationVo(BizSupplierPerformanceEvaluationConfiguration configuration) {
        try {
            BeanUtils.copyProperties(this,configuration);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}
