package com.artfess.gyl.supplierEva.model;

import com.artfess.base.entity.BizDelModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商绩效考核确认记录表
 *
 * @author huqi
 * @since 2025-11-12
 */
@Data
@TableName("biz_supplier_performance_evaluation_acknowledgement")
@ApiModel(value="BizSupplierPerformanceEvaluationAcknowledgement对象", description="供应商绩效考核确认记录表")
public class BizSupplierPerformanceEvaluationAcknowledgement extends BizDelModel<BizSupplierPerformanceEvaluationAcknowledgement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "考核评价ID")
    @TableField("PERFORMANCE_EVALUATION_ID_")
    private String performanceEvaluationId;

    @ApiModelProperty(value = "通知ID")
    @TableField("notification_id_")
    private String notificationId;

    @ApiModelProperty(value = "确认状态（1已确认，2拒绝确认）")
    @TableField("ack_status")
    private String ackStatus;

    @ApiModelProperty(value = "确认时间")
    @TableField("ack_time_")
    private LocalDateTime ackTime;

    @ApiModelProperty(value = "确认意见")
    @TableField("ack_comment_")
    private String ackComment;

    @ApiModelProperty(value = "确认人ID")
    @TableField("acknowledged_by_id_")
    private String acknowledgedById;

    @ApiModelProperty(value = "确认人ACCOUNT")
    @TableField("acknowledged_by_account_")
    private String acknowledgedByAccount;

    @ApiModelProperty(value = "确认人")
    @TableField("acknowledged_by_name_")
    private String acknowledgedByName;

    @ApiModelProperty(value = "确认方式(1线上系统，2邮件，3电话)")
    @TableField("ack_method_")
    private String ackMethod;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
