package com.artfess.gyl.supplierEva.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.valid.AddGroup;
import com.artfess.gyl.supplierAccess.dto.BizSupplierAccessConfigurationDto;
import com.artfess.gyl.supplierEva.dto.UserBindRequestDTO;
import com.artfess.gyl.supplierEva.dto.ConfigurationDTO;
import com.artfess.gyl.supplierEva.vo.ConfigurationVo;
import com.artfess.gyl.supplierEva.vo.SupplierBaseVo;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.gyl.supplierEva.model.BizSupplierPerformanceEvaluationConfiguration;
import com.artfess.gyl.supplierEva.manager.BizSupplierPerformanceEvaluationConfigurationManager;

import javax.validation.Valid;
import java.util.Arrays;
import java.util.List;

/**
 * 供应商绩效考核配置表 前端控制器
 *
 * @author huqi
 * @since 2025-11-11
 */
@RestController
@RequestMapping("/bizSupplierPerformanceEvaluationConfiguration/v1/")
@Api(tags = "供应商绩效考核配置表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ_GYL})
public class BizSupplierPerformanceEvaluationConfigurationController extends BaseController<BizSupplierPerformanceEvaluationConfigurationManager, BizSupplierPerformanceEvaluationConfiguration> {

    @PostMapping("/saveModel")
    @ApiOperation("保存供应商绩效考核配置")
    public CommonResult<String> saveModel(@ApiParam(name = "model", value = "实体信息") @Valid @RequestBody ConfigurationDTO dto) {
        Boolean result = baseService.savaModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @PostMapping("/updateModel")
    @ApiOperation("编辑供应商绩效考核配置")
    public CommonResult<String> updateModel(@ApiParam(name = "model", value = "实体信息") @Valid @RequestBody ConfigurationDTO dto) {
        Boolean result = baseService.updateModel(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @GetMapping("/getModel/{id}")
        @ApiOperation("根据id查询详情")
    public CommonResult<String> getModel(@PathVariable("id") String id) {
        ConfigurationVo model = baseService.getModel(id);
        return CommonResult.success(model,"查询成功");
    }

    @PostMapping("/updateByStatus")
    @ApiOperation(value = "根据id修改状态")
    public CommonResult<String> updateStatus(@RequestParam("id")String id,@RequestParam("status")String status) {
        boolean res = baseService.updateStatusById(id, status);
        return new CommonResult(res?"修改成功":"修改失败");
    }

    @PostMapping("/bindUser")
    @ApiOperation(value = "绑定供应商")
    public CommonResult<String> bindUser(@RequestBody UserBindRequestDTO dto) {
        boolean result = baseService.bindUser(dto);
        if (!result){
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION,null);
        }
        return CommonResult.success(dto,"保存成功");
    }

    @GetMapping(value = "/getSuppliers", produces = {"application/json; charset=utf-8"})
    @ApiOperation("企业-查询当前企业下供应商")
    public CommonResult<String> getSuppliers(@RequestParam(required = true,value = "configId")String configId,
                                             @RequestParam(required = true,value ="categoryId")String categoryId) {
        String orgId = ContextUtil.getCurrentOrgId();
        List<SupplierBaseVo> suppliers = baseService.getSuppliers(orgId,configId,categoryId);
        return CommonResult.success(suppliers,"操作成功");
    }

    @Override
    @PostMapping(value = "/query", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询结果")
    public PageList<BizSupplierPerformanceEvaluationConfiguration> query(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<BizSupplierPerformanceEvaluationConfiguration> queryFilter) {
        queryFilter.addFilter("ENTERPRISE_ID_",ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.query(queryFilter);
    }
}
