package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 生产工艺流程表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_production_process_flow3")
@ApiModel(value="BizSupplierProductionProcessFlow3对象", description="生产工艺流程表")
public class BizSupplierProductionProcessFlow3 extends BizDelModel<BizSupplierProductionProcessFlow3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "生产制造过程绩效表ID")
    @TableField("SUPPLIER_PRODUCTION_PROCESS_PERFORMANCE_ID_")
    private String supplierProductionProcessPerformanceId;

    @ApiModelProperty(value = "关键&重要过程")
    @TableField("KEY_IMPORTANT_PROCESS_")
    private String keyImportantProcess;

    @ApiModelProperty(value = "控制参数或特性")
    @TableField("CONTROL_PARAMETERS_CHARACTERISTICS_")
    private String controlParametersCharacteristics;

    @ApiModelProperty(value = "过程能力指数")
    @TableField("PROCESS_CAPABILITY_INDEX_")
    private String processCapabilityIndex;
}
