package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-主营产品生产销售情况表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_main_products_sales_status3")
@ApiModel(value="BizSupplierMainProductsSalesStatus3对象", description="主营产品情况及质量业绩表-主营产品生产销售情况表")
public class BizSupplierMainProductsSalesStatus3 extends BizDelModel<BizSupplierMainProductsSalesStatus3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "合格供应商ID")
    @TableField("SUPPLIER_ENTERPRISE_ID_")
    private String supplierEnterpriseId;

    @ApiModelProperty(value = "产品种类")
    @TableField("PRODUCT_CATEGORY_")
    private String productCategory;

    @ApiModelProperty(value = "规格")
    @TableField("SPECIFICATIONS_")
    private String specifications;

    @ApiModelProperty(value = "近三年年产量")
    @TableField("PAST_THREE_YEARS_ANNUAL_PRODUCTION_")
    private String pastThreeYearsAnnualProduction;

    @ApiModelProperty(value = "交货周期")
    @TableField("DELIVERY_CYCLE_")
    private String deliveryCycle;

    @ApiModelProperty(value = "主要客户及市场")
    @TableField("MAIN_CUSTOMERS_MARKETS_")
    private String mainCustomersMarkets;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;
}
