package com.artfess.gyl.supplierApply3.model;

import com.artfess.base.entity.BizDelModel;
import com.artfess.file.model.DefaultFile;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 主营产品情况及质量业绩表-主营产品质量表现表
 *
 * @author huqi
 * @since 2025-11-17
 */
@Data
@TableName("biz_supplier_main_products_quality_performance3")
@ApiModel(value="BizSupplierMainProductsQualityPerformance3对象", description="主营产品情况及质量业绩表-主营产品质量表现表")
public class BizSupplierMainProductsQualityPerformance3 extends BizDelModel<BizSupplierMainProductsQualityPerformance3> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主营产品情况及质量业绩ID")
    @TableField("SUPPLIER_MAIN_PRODUCTS_PERFORMANCE_ID_")
    private String supplierMainProductsPerformanceId;

    @ApiModelProperty(value = "产品名称及规格")
    @TableField("PRODUCT_NAME_")
    private String productName;

    @ApiModelProperty(value = "去年质量目标-指标")
    @TableField("LAST_YEAR_QUALITY_TARGET_INDEX_VALUE_")
    private String lastYearQualityTargetIndexValue;

    @ApiModelProperty(value = "去年质量目标-实际值")
    @TableField("LAST_YEAR_QUALITY_TARGET_ACTUAL_VALUE_")
    private String lastYearQualityTargetActualValue;

    @ApiModelProperty(value = "今年质量目标-指标")
    @TableField("THIS_YEAR_QUALITY_TARGET_INDEX_VALUE_")
    private String thisYearQualityTargetIndexValue;

    @ApiModelProperty(value = "今年质量目标-实际值")
    @TableField("THIS_YEAR_QUALITY_TARGET_ACTUAL_VALUE_")
    private String thisYearQualityTargetActualValue;

    @ApiModelProperty(value = "拟提供我司产品")
    @TableField("COMPANY_PRODUCT_")
    private String companyProduct;

    @ApiModelProperty(value = "企业业绩")
    @TableField("PERFORMANCE_")
    private String performance;

    @ApiModelProperty(value = "附件集")
    @TableField(exist = false)
    private List<DefaultFile> files;


}
