package com.artfess.gyl.supplierApply2.vo;

import com.artfess.gyl.supplierApply2.dto.BizSupplierReviewReport2Dto;
import com.artfess.gyl.supplierApply2.dto.BizSupplierReviewTrialReport2Dto;
import com.artfess.gyl.supplierApply2.model.*;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;

@Data
public class EnterpriseAccess2Vo extends BizSupplierEnterpriseAccess {

    @ApiModelProperty(value = "供应商主供物资分类")
    private List<BizSupplierMainSupplyMaterialCategory2> materialCategory2List;

    @ApiModelProperty(value = "供应商基本情况")
    private BizSupplierAccessBasicInformation2Vo information;

    @ApiModelProperty(value = "企业资质（1必传资质，2选传资质，3其他资质）-Map集合")
    private Map<String, List<BizSupplierEnterpriseQualificationDatabase2>> qualificationMap;

    @ApiModelProperty(value = "主营产品质量业绩")
    private MainProductsPerformance2Vo mainProductsPerformance;

    @ApiModelProperty(value = "主要原材料及供应商")
    private List<BizSupplierMainRawMaterialsSuppliers2>  rawMaterialsSuppliersList;

    @ApiModelProperty(value = "生产制造过程绩效")
    private BizSupplierProductionProcessPerformance2Vo processPerformance;

    @ApiModelProperty(value = "生产及检验设备（1生产设备，2监测设备）-Map集合")
    private Map<String,List<BizSupplierProductionInspectionEquipment2>> inspectionEquipmentMap;

    @ApiModelProperty(value = "其他特别说明")
    private BizSupplierOtherSpecialNotes2 otherSpecialNotes;

    @ApiModelProperty(value = "现场评审")
    private Map<String,List<BizSupplierReviewRatingDetails2Vo>> reviewRatingDetails2Map;

    @ApiModelProperty(value = "评定报告")
    BizSupplierReviewReport2Vo reviewReport;

    @ApiModelProperty(value = "试生产评审")
    BizSupplierReviewTrialReport2Vo reviewTrialReport;

//    @ApiModelProperty(value = "人员信息")
//    private Map<String,List<BizSupplierAccessPersonnel2>> accessPersonnelMap;

    @ApiModelProperty(value = "人员信息")
    private List<BizSupplierAccessEnterprisePersonnel2> enterprisePersonnelList;

    @ApiModelProperty(value = "主营产品情况")
    List<BizSupplierMainProductsSalesStatus2> salesStatus2List;

    @ApiModelProperty(value = "主要检验设备")
    private List<BizSupplierInspectionEquipment2> inspectionEquipment2List;

    @ApiModelProperty(value = "主要生产设备")
    private List<BizSupplierProductionEquipment2> productionEquipment2List;


    public EnterpriseAccess2Vo(){}

    public EnterpriseAccess2Vo(BizSupplierEnterpriseAccess enterpriseAccess){
        try {
            BeanUtils.copyProperties(this,enterpriseAccess);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        } catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}
